function patchMedians = computePatchMedian(patches)
    %compute the median image for a collection of patches
    %also handle the depth 
    patchMedians.patchNx = medianNaNFiltered(patches.patchNx, patches.patchValid);
    patchMedians.patchNy = medianNaNFiltered(patches.patchNy, patches.patchValid);
    patchMedians.patchNz = medianNaNFiltered(patches.patchNz, patches.patchValid);
    if isfield(patches,'patchDepth')
        patchMedians.patchDepth = medianNaNFiltered(patches.patchDepth, patches.patchDepth > 0);
        patchMedians.patchDepthNorm = medianNaNFiltered(patches.patchDepthNorm, patches.patchDepth > 0);
    end
end

function maskedMedian = medianNaNFiltered(image, valid)
    %compute the median, ignore invalid values
    masked = image;
    masked(~valid) = NaN;
    maskedMedian = nanmedian(masked,3); 
end
