function writeOutPatches(patches, outDir, canonicalSize, namePrefix, ...
  scores)
if ~exist('scores', 'var')
  scores = zeros(size(patches));
end

for i = 1 : length(patches)
  D = patches(i);
  I = im2double(imread(D.im));
  if D.flip
    I(:,:,1) = fliplr(I(:,:,1));
    I(:,:,2) = fliplr(I(:,:,2));
    I(:,:,3) = fliplr(I(:,:,3));
  end

  I = getSubImg(I, D);
  I1 = imresize_old(I, canonicalSize, 'bilinear');
  suffix = sprintf('%.6d_%.3f.jpg', i, scores(i));
  imwrite(I1, [outDir namePrefix suffix]);
end

% Write a dummy image if there are no images.
if isempty(patches)
  dummy = zeros(canonicalSize);
  imwrite(dummy, [outDir namePrefix 'no_patch.jpg']);
end
end

