function [selected, toDrop] = selectTopRankedLessOverlapping( ...
  finalWts, coccurOverlap, toSelect)
overlapFreq = sum(coccurOverlap(:, :, 6:10), 3);
numAllowed = 4;
[srtWts, srtInds] = sort(finalWts, 'descend');

selected = [];
remClust = srtInds;
toDrop = false(size(srtInds));
while length(selected) < toSelect && ~isempty(remClust)
  currCl = remClust(1);
  toDrop(currCl) = true;
  overlaps = overlapFreq(currCl, :);
  violating = overlaps > numAllowed;
  toDrop(violating) = true;
  selected = [selected; currCl];
  remClust = srtInds(~toDrop(srtInds));
end
end
