function tripletActivationCount = generateTripletVisualization( ...
  selTriplet, hiloBit, imgSet, topN, patMos, selectedClusters, saveDir)

% Compute some metadata.
[topDetImgInd, topDetBakInd] = computeProcessingMetadata( ...
  length(imgSet), topN);
% Compute the image to clusters tally.
imgPatTally = computeImgPatchTally(topN, length(imgSet));

set(0, 'DefaultFigurePosition', [1, 1, 1000, 600]);
fig1 = figure(1);
mkdir(saveDir);
clrStr = 'cmy';
tripletActivationCount = zeros(size(selTriplet, 1), 1);
counter = 1;
pBar = createProgressBar();
for i = 1 : length(imgSet)
  pBar(i, length(imgSet));
  imgTally = imgPatTally(i, :);
  presentTrips = sum(imgTally(selTriplet), 2) == 3;
  presentTripsInds = find(presentTrips);
  bx = getBoxesForPedro(topDetImgInd{i});
  overl = computeOverlap(bx, bx, 'pascal');
  
  hiol = overl >= 0.4;
  hiol = triu(hiol, 1);
  hiol = hiol + hiol';
  lool = overl < 0.2;
  lool = triu(lool, 1);
  lool = lool+ lool';
  
  trips = selTriplet(presentTrips, :);
  hilobPre = hiloBit(presentTrips, :);
  I = imread(topDetImgInd{i}(1).im);
  
  for j = 1 : size(trips, 1)
    hilob = hilobPre(j, :);
    c1 = find(topDetBakInd{i}(:, 1) == trips(j, 1));
    c2 = find(topDetBakInd{i}(:, 1) == trips(j, 2));
    c3 = find(topDetBakInd{i}(:, 1) == trips(j, 3));
    for p = 1 :length(c1)
      for q = 1 : length(c2)
        if ~hiol(c1(p), c2(q))
          continue;
        end
        for r = 1 : length(c3)
          if hilob(2) && ~hiol(c1(p), c3(r))
            continue;
          elseif ~hilob(2) && ~lool(c1(p), c3(r))
            continue;
          end
          if hilob(3) && ~hiol(c2(q), c3(r))
            continue;
          elseif ~hilob(3) && ~lool(c2(q), c3(r))
            continue;
          end
          tripletActivationCount(presentTripsInds(j)) = ...
            tripletActivationCount(presentTripsInds(j)) + 1;
          
          clf;
          subplot(2, 4, 1);
          imshow(patMos{trips(j, 1)});
          title(sprintf('1 : %d', selectedClusters(trips(j, 1))));
          subplot(2, 4, 2);
          imshow(patMos{trips(j, 2)});
          title(sprintf('2 : %d', selectedClusters(trips(j, 2))));
          subplot(2, 4, 5);
          imshow(patMos{trips(j, 3)});
          title(sprintf('3 : %d', selectedClusters(trips(j, 3))));
          subplot(2, 4, [3 4 7 8]);
          imshow(I);
          hold on;
          displayPatchBox(topDetImgInd{i}(c1(p)), 1, clrStr(1));
          displayPatchBox(topDetImgInd{i}(c2(q)), 2, clrStr(2));
          displayPatchBox(topDetImgInd{i}(c3(r)), 3, clrStr(3));
          hold off;
          ovStr = sprintf('Im: %d Ov(%.2f, %.2f, %.2f) ', ...
            imgSet(i), overl(c1(p), c2(q)), ...
            overl(c1(p), c3(r)), overl(c2(q), c3(r)));
          clStr = sprintf('Cl: %d, %d, %d ', ...
            selectedClusters(trips(j, :)));
          tripCnt = sprintf(' Count: %d', ...
            tripletActivationCount(presentTripsInds(j)));
          title([ovStr clStr tripCnt]);
          saveas(fig1, [saveDir sprintf('%d_%d.jpg', ...
            presentTripsInds(j), counter)], 'jpg');
          counter = counter + 1;
%           keyboard;
        end
      end
    end
  end
end
end

function [topDetImgInd, topDetBakInd] = computeProcessingMetadata( ...
  numImgs, topN)
topDetImgInd = cell(1, numImgs);
topDetBakInd = cell(1, numImgs);
pBar = createProgressBar();
for i = 1 : length(topN)
  pBar(i, length(topN));
  for j = 1 : length(topN{i}.meta)
    id = topN{i}.imgIds(j);
    topDetImgInd{id} = [topDetImgInd{id} topN{i}.meta(j)];
    topDetBakInd{id} = [topDetBakInd{id}; i j];
  end
end
end


function imgPatTally = computeImgPatchTally(topN, numImgs)
imgPatTally = false(numImgs, length(topN));
for i = 1 : length(topN)
  imgPatTally(topN{i}.imgIds, i) = true;
end
end
