function generateSupportVectorPatches(dets, selectedClusters, params, ...
  rootDir, iterId, positivePatches, posFeatures, negativePatches, ...
  negFeatures)
% Generates patch images for the support vectors.

subDir = [iterId '/'];
patchImgDir = [rootDir subDir];
if ~exist(patchImgDir, 'dir')
  mkdir(patchImgDir);
end

info = dets.firstLevModels.info;
canoSize = params.patchCanonicalSize;
prSize = round(params.patchCanonicalSize(1) / params.sBins) - 2;
pcSize = round(params.patchCanonicalSize(2) / params.sBins) - 2;
perClusterRows = 5;
dispData = cell(length(info) * 2, 1);
pBar = createProgressBar();
for i = 1 : length(info)
  pBar(i, length(info));
  
  namePrefix = sprintf('%d_wt_', selectedClusters(i));
  detWts = dets.firstLevModels.w(i, :);
  detWts = reshape(detWts, prSize, pcSize, []);
  wtPic = myVisualizeHOG(detWts);
  im = convertToImagescImg(wtPic);
  fileName = sprintf('%s%d.jpg', namePrefix, i);
  imwrite(im, [rootDir subDir fileName], 'jpg');
  dispData{perClusterRows*i-4}{1} = 'SVM';
  dispData{perClusterRows*i-4}{2} = sprintf( ...
      '<img src="%s" title="%s">', [subDir fileName], fileName);
  
  posInds = info{i}.posSVInds;
  negInds = info{i}.negSVInds;
  if length(negativePatches) ~= info{i}.numNegatives
    error('Different number of negative features, possible error');
  end

  namePrefix = sprintf('%d_pos_', selectedClusters(i));
  scores = zeros(size(posInds));
  posPats = positivePatches(posInds);
  writeOutPatches(posPats, patchImgDir, canoSize, ...
    namePrefix, scores);
  dispData{perClusterRows*i-3}{1} = sprintf('%d pos sv (%d)', ...
    selectedClusters(i), length(posInds));
  
  offset = 1;
  for j = 1 : length(posPats)
    fileName = sprintf('%s%.6d_%.3f.jpg', [subDir namePrefix], j, ...
      scores(j));
    dispData{perClusterRows*i-3}{offset + j} = sprintf( ...
      '<img src="%s" title="%s">', fileName, fileName);
  end
  
  dispData{perClusterRows*i-2} = generateHOGImages( ...
    posFeatures(posInds, :), prSize, pcSize, ...
    rootDir, subDir, namePrefix);

  namePrefix = sprintf('%d_neg_', selectedClusters(i));
  scores = zeros(size(negInds));
  negPats = negativePatches(negInds);
  writeOutPatches(negPats, patchImgDir, canoSize, ...
    namePrefix, scores);
  dispData{perClusterRows*i-1}{1} = sprintf('%d neg sv (%d)', ...
    selectedClusters(i), length(negInds));
  
  offset = 1;
  for j = 1 : length(negPats)
    fileName = sprintf('%s%.6d_%.3f.jpg', [subDir namePrefix], j, ...
      scores(j));
    dispData{perClusterRows*i-1}{offset + j} = sprintf( ...
      '<img src="%s" title="%s">', fileName, fileName);
  end
  
  dispData{perClusterRows*i} = generateHOGImages( ...
    negFeatures(negInds, :), prSize, pcSize, ...
    rootDir, subDir, namePrefix);
end
generateHtmlPageWithTable(dispData, [rootDir iterId '.html']);
end

function dispData = generateHOGImages(features, prSize, pcSize, ...
  rootDir, subDir, prefix)
numFeats = size(features, 1);
dispData = cell(1, numFeats + 1);
dispData{1} = 'HOG';
offset = 1;
for i = 1 : numFeats
  w = features(i, :);
  w = reshape(w, prSize, pcSize, []);
  hogPic = myVisualizeHOG(w);
  im = convertToImagescImg(hogPic);
  fileName = sprintf('%s%d.jpg', prefix, i);
  imwrite(im, [rootDir subDir fileName], 'jpg');
  dispData{offset + i} = sprintf( ...
      '<img src="%s" title="%s">', [subDir fileName], fileName);
end
end
