function overlapScore = computeTopNOverlap(top1, top2)
toSel = min([length(top1.meta) length(top2.meta) 5]);
imgs1 = top1.imgIds(1:toSel);
imgs2 = top2.imgIds(1:toSel);
commonImgs = intersect(imgs1, imgs2);
allInds = 1 : toSel;
overlapScore = 0;
for i = 1 : length(commonImgs)
  [mem1, unused] = ismember(imgs1, commonImgs(i));
  [mem2, unused] = ismember(imgs2, commonImgs(i));
  m1 = top1.meta(allInds(mem1));
  m2 = top2.meta(allInds(mem2));
  bx1 = getBoxesForPedro(m1);
  bx2 = getBoxesForPedro(m2);
  overlaps = computeOverlap(bx1, bx2, 'pascal');
  overlapScore = overlapScore + sum(max(overlaps, [], 2));
end
overlapScore = overlapScore / toSel;
end
