function [relLoc, c1Sc, imgs, c1Ind, c2Ind] = ...
  computeCanonicalRelativeLocationsTopN( ...
    cl2, cl1Res, cl1ResImgIds, topN, cl2Thresh)
% Computes the location of cl2 relative to cl1 from the given data.

numPats = length(topN.meta);
pairRelation = cell(numPats, 1);
pairC1Scores = cell(numPats, 1);
pairImgs = cell(numPats, 1);
c1Ind = cell(numPats, 1);
c2Ind = cell(numPats, 1);
pairInd = 0;
pBar = createProgressBar();
for i = 1 : numPats
  pBar(i, numPats);
  imId = topN.imgIds(i);
  resInd = cl1ResImgIds == imId;
  rs = cl1Res(resInd);
  d2 = rs.firstLevel.detections(cl2);
  toSel = d2.decision > cl2Thresh;
  d2Meta = d2.metadata(toSel);
  if ~isempty(d2Meta)
    b1 = getBoxesForPedro(topN.meta(i));
    b2 = getBoxesForPedro(d2Meta);
    sc1 = b1(1, 3) - b1(1, 1);
    sc2 = b2(:, 3) - b2(:, 1);
    
    b1t = repmat(b1, size(b2, 1), 1);
    sc1t = ones(size(b2, 1), 1) * sc1;
    [b1trfor, b2trfor] = transformWithBox1AsCano(b1t, b2);
    metrfor = [mean(b2trfor(:, [1 3]), 2) mean(b2trfor(:, [2 4]), 2)];
    fe = [metrfor sc2 ./ sc1t];
    pairInd = pairInd + 1;
    pairC1Scores{pairInd} = ones(size(fe, 1), 1) * topN.scores(i);
    pairImgs{pairInd} = ones(size(fe, 1), 1) * imId;
    c1Ind{pairInd} = ones(size(fe, 1), 1) * i;
    c2Ind{pairInd} = find(toSel);
    pairRelation{pairInd} = fe;
%     keyboard;
  end
end

relLoc = pairRelation(1 : pairInd);
c1Sc = pairC1Scores(1 : pairInd);
imgs = pairImgs(1 : pairInd);
c1Ind = c1Ind(1 : pairInd);
end
