function boxes = clipBoxesToBoundary(boxes, imSize)
% Clip a box to the image boundary
%
% Author: saurabh.me@gmail.com (Saurabh Singh).

if ~isempty(boxes)
  boxes(:,1) = max(boxes(:,1), 1);
  boxes(:,2) = max(boxes(:,2), 1);
  boxes(:,3) = min(boxes(:,3), imSize(2));
  boxes(:,4) = min(boxes(:,4), imSize(1));

  % remove invalid detections
  w = boxes(:,3)-boxes(:,1)+1;
  h = boxes(:,4)-boxes(:,2)+1;
  I = (w <= 0) | (h <= 0);
  boxes(I, :) = [];
end
end
