function sumDist = getSumLocDistribution(rows, cols, gmm, patches)
% Generates a distribution centered at the patch. 
[imgY imgX] = ind2sub([rows cols], (1 : rows * cols)');
  
probs = zeros(size(imgX));
for i = 1 : length(patches)
  vertExt = getVerticalExtent(patches(i));
  [pcx pcy] = getCenter(patches(i));
  
  newImgX = (imgX - pcx) / vertExt;
  newImgY = (imgY - pcy) / vertExt;
  probs = probs + pdf(gmm, [newImgX newImgY]);    
end
sumDist = reshape(probs, [rows cols]);
sumDist = weighByVariance(gmm, sumDist);
end

function newSumDist = weighByVariance(gmm, sumDist)
weight = 0;
for i = 1 : length(gmm.PComponents)
  weight = weight + sqrt(trace(gmm.Sigma(:, :, i))) * gmm.PComponents(i);
end
newSumDist = sumDist * (1 / (1 + weight));
end

function [cx cy] = getCenter(data)
cx = (data.x1 + data.x2) / 2;
cy = (data.y1 + data.y2) / 2;
end

function ext = getVerticalExtent(data)
ext = abs(data.y2 - data.y1);
end
