function [perImgMeta, perImgScore, backMapInd] = mapTopNToImg(imgSet, topN, N)
% N: Number of top detections to consider.
numImgs = length(imgSet);
perImgMeta = cell(numImgs);
backMapInd = cell(numImgs);
perImgScore = cell(numImgs);
pBar = createProgressBar();
for i = 1 : length(topN)
  pBar(i, length(topN));
  toSel = min(length(topN{i}.meta), N);
  for j = 1 : toSel
    id = find(topN{i}.imgIds(j) == imgSet);
    perImgMeta{id} = [perImgMeta{id}; topN{i}.meta(j)];
    perImgScore{id} = [perImgScore{id}; topN{i}.scores(j)];
    backMapInd{id} = [backMapInd{id}; i j];
  end
end
end
