function dist = getEmptyDistribution(space, uniformWt)
% Creates an empty distribution.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).
ncols = length(space.xSpace);
nrows = length(space.ySpace);
nscales = length(space.scaleSpace);
naspects = length(space.aspectSpace);
dist = zeros(nrows, ncols, nscales, naspects);
if exist('uniformWt', 'var') && uniformWt
  dist = dist + (1 / (nrows * ncols * nscales * naspects));
end
end
