function voteLoc = getDetectionVoteLocations(detections, votes)
% Comptues the vote locations for each detection using the votes.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).
voteLoc = cell(size(detections));
for i = 1 : length(detections)
  vertExt = getPatchVerticalExtent(detections(i));
  [pcx pcy] = getPatchCenter(detections(i));

  patchVotes = votes;
  patchVotes(:, 1) = (patchVotes(:, 1) * vertExt) + pcx;
  patchVotes(:, 2) = (patchVotes(:, 2) * vertExt) + pcy;
  patchVotes(:, 3) = patchVotes(:, 3) * vertExt;
  % Clip the votes to the image boundaries
  patchVotes = correctLocationsForImageSize(patchVotes, ...
    detections(i).size.nrows, detections(i).size.ncols);
  voteLoc{i} = patchVotes;
end
end
