function [ptsPos, ptsNeg] = eliminatePointsNearPositives(peaks, positives, ...
  locationSpace)
% Eliminates points near given positives in the location space.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).
ptsNeg = [];
ptsPos = [];

for i = 1 : size(peaks, 1)
  p = peaks(i, :);
  toInclude = true;
  for j = 1 : size(positives, 1)
    s = positives(j, :);
    sy = s(3) / 2;
    sx = (tan(s(4) * (pi/2)) * sy) / 2;
    ss = 2*abs(locationSpace.scaleSpace(2) - locationSpace.scaleSpace(1));
    sa = 2*(1 / length(locationSpace.aspectSpace));
    
    if p(1) < s(1) - sx || p(1) > s(1) + sx
      continue;
    elseif p(2) < s(2) - sy || p(2) > s(2) + sy
      continue;
    elseif p(3) < s(3) - ss || p(3) > s(3) + ss
      continue;
    elseif p(4) < s(4) - sa || p(4) > s(4) + sa
      continue;
    end
    toInclude = false;
%     fprintf('Point dropped\n');
%     p
  end
  if toInclude
%     fprintf('Point included\n');
%     p
    ptsNeg = [ptsNeg; p];
  else
    ptsPos = [ptsPos; p];
  end
end
end
