function newTopN = doMinOverlapTopN(topN, imgSet, overlapThresh)
[perImgMeta, perImgScore, backMapInd] = mapTopNToImg(imgSet', topN);
perImgPicks = cell(size(imgSet'));
for i = 1 : length(perImgMeta)
  bx = getBoxesForPedro(perImgMeta{i}, perImgScore{i});
  picks = myNmsPascal(bx, overlapThresh);
  perImgPicks{i} = false(size(perImgScore{i}));
  perImgPicks{i}(picks) = true;
end
newTopN = mapBackToTopN(perImgPicks, backMapInd, topN);
end

function newTopN = mapBackToTopN(perImgPicks, backMapInd, topN)
picks = cell2mat(perImgPicks);
mapInds = cell2mat(backMapInd);
newTopN = cell(size(topN));
for i = 1 : size(mapInds, 1)
  i1 = mapInds(i, 1);
  i2 = mapInds(i, 2);
  if isempty(newTopN{i1})
    newTopN{i1}.meta = getEmptyPascalStruct();
    newTopN{i1}.scores = [];
    newTopN{i1}.imgIds = [];
  end
  if ~picks(i)
    continue;
  end
  newTopN{i1}.meta = [newTopN{i1}.meta topN{i1}.meta(i2)];
  newTopN{i1}.scores = [newTopN{i1}.scores topN{i1}.scores(i2)];
  newTopN{i1}.imgIds = [newTopN{i1}.imgIds topN{i1}.imgIds(i2)];
end
fprintf('Num dropped: %d/%d\n', sum(~picks), length(picks));
end
