function sumDist = doDistributionGenForImage2D(detectors, ...
  detResult, data, preferableClusts)

rows = data.annotation.imagesize.nrows;
cols = data.annotation.imagesize.ncols;

sumDist = zeros(rows, cols) + (1 / (rows * cols));
for j = preferableClusts
  det = detResult.detections(j);
  if isempty(det.metadata)
    continue;
  end
  distrib = getSumLocDistNonPara(rows, cols, ...
    detectors.mixModels{j}.location , ...
    det.metadata);
  successWeight = 3 / (1 + exp(-detectors.successRatios(j)));
  sumDist = sumDist + successWeight * distrib;
end
% Normalize to make it a distribution.
% sumDist = sumDist ./ sum(sum(sumDist));
end

