function [newPoints, toInclude] = correctLocationsForImageSize(points, ...
  nrows, ncols)
% Correct the predicted boxes by clipping at the image boundary.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).

if nargout < 2
  error('There are two output arguments.');
end

newPoints = points;
points = convertLocationToBoxCoods(points);
toInclude = eliminateBoxesOutsideImage(points, nrows, ncols);
points = points(toInclude, :);
points(points(:, 1)<1, 1) = 1;
points(points(:, 3)>ncols, 3) = ncols;
points(points(:, 2)<1, 2) = 1;
points(points(:, 4)>nrows, 4) = nrows;
points = convertBoxToLocationSpaceCoods(points);
newPoints(toInclude, :) = points;
end
