function [posScores, negScores] = computeDetScoresPerImage(results, posSet, ...
  negSet)

resultFn = @(x) results.getPosResult(x);
posScores = getScores(posSet, resultFn);
resultFn = @(x) results.getNegResult(x);
negScores = getScores(negSet, resultFn);
end

function scores = getScores(imgSet, resultFn)
scores = [];
pBar = createProgressBar();
for i = 1 : length(imgSet)
  pBar(i, length(imgSet));
  res = resultFn(imgSet(i));
  if isempty(scores)
    scores = zeros(length(imgSet), length(res.firstLevel.detections));
  end
  
  thisScores = zeros(size(res.firstLevel.detections));
  for j = 1 : length(res.firstLevel.detections)
    x = res.firstLevel.detections(j);
    if isempty(x.decision)
      thisScores(j) = -1.1;
    else
      thisScores(j) = max(x.decision);
    end
  end
  scores(i, :) = thisScores;
end
end
