function [data, actionClasses] = getPascal2010ActionData(imgset, libHome)
% [pos, neg] = pascalData(cls)
%
% Get training data from the PASCAL dataset. Adapted from Pedro's code.

VOCdevkit = [libHome 'pascal-voc/2010/VOCdevkit/VOCcode/'];
pascalInit;

ids = textread(sprintf(VOCopts.action.imgsetpath, imgset), '%s');
data = [];
for i = 1 : length(ids);
  fprintf('parsing positives: %d/%d\n', i, length(ids));
  rec = PASreadrecord(sprintf(VOCopts.annopath, ids{i}));
  
  item = [];
  item.filename = rec.filename;
  item.folder = '';
  item.imagesize.nrows = rec.size.height;
  item.imagesize.ncols = rec.size.width;
  object = [];
  for j = 1 : length(rec.objects)
    object(j).name = rec.objects(j).class;
    object(j).id = j;
    object(j).crop = rec.objects(j).truncated;
    object(j).polygon.x = [ ...
      rec.objects(j).bndbox.xmin, ...
      rec.objects(j).bndbox.xmax, ...
      rec.objects(j).bndbox.xmax, ...
      rec.objects(j).bndbox.xmin, ...
    ];
    object(j).polygon.y = [ ...
      rec.objects(j).bndbox.ymin, ...
      rec.objects(j).bndbox.ymin, ...
      rec.objects(j).bndbox.ymax, ...
      rec.objects(j).bndbox.ymax, ...
    ];
    object(j).polygon.t = 1;
    object(j).polygon.key = 1;
    object(j).actions = rec.objects(j).actions;
  end
  item.object = object;
  item.id = ids{i};
  data(i).annotation = item;
end
actionClasses = VOCopts.actions;
end  
