function data = getIndoor67Data(imgset, config)
% [pos, neg] = getIndoor67Data(imgset)
%
% Get data for the indoor dataset.

switch(imgset)
  case 'train'
    metaFile = 'TrainImages.txt';
  case 'test'
    metaFile = 'TestImages.txt';
  otherwise
    error('Unrecognized image set request: %s', imgSet);
end

metaFile = [config.indoor67Home metaFile];
files = textscan(fopen(metaFile), '%s', 'whitespace', '\b\t');
files = files{1};

data = struct('annotation', []);
data(length(files)).annotation = [];

for i = 1 : length(files);
  fprintf('%s parsing files: %d/%d\n', imgset, i, length(files));
  I = imread([config.indoor67ImgHome files{i}]);
  [rows, cols, chans] = size(I);
  prefixEnd = strfind(files{i}, '/');
  label = files{i}(1:prefixEnd-1);
  item = [];
  item.filename = files{i};
  item.folder = '';
  item.imagesize.nrows = rows;
  item.imagesize.ncols = cols;
  item.label = label;
  object = [];
  object.name = label;
  object.id = 1;
  object.crop = false;
  object.polygon.x = [ ...
    1, ...
    cols, ...
    cols, ...
    1, ...
  ];
  object.polygon.y = [ ...
    1, ...
    1, ...
    rows, ...
    rows, ...
  ];
  object.polygon.t = 1;
  object.polygon.key = 1;
  
  item.object = object;
  data(i).annotation = item;
end
end  
