function topN = supressClustersBasedOnMutualOverlaps(topN, mutualOverlaps, ...
  thresh)
overlapScores = sum(mutualOverlaps);
overlapping = triu(mutualOverlaps, 1) > thresh;
[x, y] = find(overlapping);
for i = 1 : length(x)
  if overlapScores(x(i)) > overlapScores(y(i))
    toSupress = y(i);
  else
    toSupress = x(i);
  end
  topN{toSupress}.meta = getEmptyPascalStruct();
  topN{toSupress}.scores = [];
  topN{toSupress}.imgIds = [];
end
fprintf('Total suppressed %d\n', length(x));
end
