function [affinity, d] = getL2DistanceAffinity(features)
% Affinity by normal L2 distance.
w = exp(-features);
a = sum(features .* features, 2);
ata = repmat(a, 1, size(features, 1));
btb = ata';
bta = features * features';
atb = bta';
d = ata + btb - bta - atb;
h = 0.1;
affinity = exp(-h * d);
end
