function hasConverged = getConvergedClusters(top1, top2)
cp1 = top1.clustInfo.clusterInformation.clustersToProcess;
cp2 = top2.clustInfo.clusterInformation.clustersToProcess;
hasConverged = false(size(cp1));
oScore = zeros(size(cp1));
for i1 = 1 : length(cp1)
  cl1 = cp1(i1);
  [mem, i2] = ismember(cl1, cp2);
  if ~mem
    continue;
  end
  
  oScore(i1) = computeTopNOverlap(top1.topN.topN{i1}, top2.topN.topN{i2});
  if oScore(i1) > 0.96
%     disp('converged!!');
    hasConverged(i1) = true;
  end
%   pause; 
end
end
