function generateClusterView(outFile, patchImgDir, clusters, assignedClust, ...
  clusterData, patchesData)
% Generates a view of the clusters.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).
if ~exist('clusterData', 'var')
  clusterData = struct([]);
end
if ~exist('patchesData', 'var')
  patchesData = struct([]);
end

dispData = cell(length(clusters), 1);
for i = 1 : length(clusters)
  patIds = find(assignedClust==clusters(i));
  dispData{i} = cell(length(patIds), 1);
  dispData{i}{1} = getClusterTitle(clusters, i, clusterData);
  offset = 1;
  for j = 1 : length(patIds)
    patchTitle = getPatchTitle(patchesData, patIds(j));
    dispData{i}{offset + j} = sprintf( ...
      '<img src="%s%d.jpg" title="%s">', patchImgDir, patIds(j), ...
      patchTitle);
  end
end
generateHtmlPageWithTable(dispData, outFile);
end

function patchTitle = getPatchTitle(patchData, patInd)
patchTitle = '';
fieldNames = fieldnames(patchData);
patchTitle = '';
for i = 1 : length(fieldNames)
  val = getfield(patchData, fieldNames{i});
  patchTitle = [patchTitle sprintf('%s: %3f ', fieldNames{i}, ...
    val(patInd))];
end
end

function clusterTitle = getClusterTitle(clusters, clusterInd, clusterData)
clusterTitle = sprintf('%d', clusters(clusterInd));
if ~isempty(clusterData)
  fieldNames = fieldnames(clusterData);
  for i = 1 : length(fieldNames)
    val = getfield(clusterData, fieldNames{i});
    clusterTitle = [clusterTitle sprintf('%s: %3f ', fieldNames{i}, ...
      val(patInd))];
  end
end
end
