(* 
 * An inplementation of lazy natural numbers 
 *)

letrec LNAT =
  dcds
    cell B values 0,1
    graft (LNAT.s) access B = 1
  end;


(* Some constants *)
let Zero = {B=0};
let S1 = {B=1};
let One = {B=1,(B.s)=0};
let S2 = {B=1,(B.s)=1};
let Two = {B=1,(B.s)=1,((B.s).s)=0};
let S3 = {B=1,(B.s)=1,((B.s).s)=1};
let Three = {B=1,(B.s)=1,((B.s).s)=1,(((B.s).s).s)=0};
let S4 = {B=1,(B.s)=1,((B.s).s)=1,(((B.s).s).s)=1};


(* The infinite element *)
let Srec = algo
  request B do
    output 1
  end
  request ((B.$V).s) do
    valof (B.$V) is
      1 : output 1
    end
  end
end;

let Somega = fix(Srec);


(* Predecessor *)
let pred_rec = algo
  request {}B do
    output valof B
  end
  request {B=0}B do
    output output 0
  end
  request {B=1}B do
    output valof (B.s)
  end
  request {B=1,(B.s)=0}B do
    output output 0
  end
  request {B=1,(B.s)=1}B do
    output output 1
  end
  request {}(B.$V) do
    output valof ((B.$V).s)
  end
  request {((B.$V).s)=0}(B.$V) do
    output output 0
  end
  request {((B.$V).s)=1}(B.$V) do
    output output 1
  end
end;

let pred = fix(pred_rec);


(* Successor *)
let succ_rec = algo
  request {}B do
    output output 1
  end
  request {}((B.$V).s) do
    output valof (B.$V)
  end
  request {(B.$V)=0}((B.$V).s) do
    output output 0
  end
  request {(B.$V)=1}((B.$V).s) do
    output output 1
  end
end;

let S = fix(succ_rec);


(* This algorithm has the property that
       [[ a ]] (S n(bot), S p(bot)) = S {min(n,p)}(bot).
   This shows that sequential algorithms are more expressive than
   primitive recursive ones. *)
let a_rec = algo
  request {}B do
    output valof (B.1)
  end
  request {(B.1)=1}B do
    output valof (B.2)
  end
  request {(B.1)=1,(B.2)=1}B do
    output output 1
  end
  request {}((B.$V).s) do
    valof {}(B.$V) is
      valof ((B.$V).1) : output valof (((B.$V).s).1)
    end
  end
  request {(((B.$V).s).1)=1}((B.$V).s) do
    from {{}(B.$V)=valof ((B.$V).1)} do
      valof {((B.$V).1)=1}(B.$V) is
        valof ((B.$V).2) : output valof (((B.$V).s).2)
      end
    end
  end
  request {(((B.$V).s).1)=1,(((B.$V).s).2)=1}((B.$V).s) do
    from {{}(B.$V)=valof ((B.$V).1),{((B.$V).1)=1}(B.$V)=valof ((B.$V).2)} do
      valof {((B.$V).1)=1,((B.$V).2)=1}(B.$V) is
        output 1 : output output 1
      end
    end
  end
end;

let a = fix(a_rec);


(* This computes a min function in O(min). It has the properties:
       [[ left_min ]] (S n(0), S p(0)) = S {min(n,p)}(0)
       [[ left_min ]] (S n(bot), S p(bot)) = S {min(n,p)}(bot)
       [[ left_min ]] (S n(0), S n(bot)) = S n(0)
       [[ left_min ]] (S n(bot), S n(0)) = S n(bot)
*)
let left_min_rec = algo
  request {}B do
    output valof (B.1)
  end
  request {(B.1)=0}B do
    output output 0
  end
  request {(B.1)=1}B do
    output valof (B.2)
  end
  request {(B.1)=1,(B.2)=0}B do
    output output 0
  end
  request {(B.1)=1,(B.2)=1}B do
    output output 1
  end
  request {}((B.$V).s) do
    valof {}(B.$V) is
      valof ((B.$V).1) : output valof (((B.$V).s).1)
    end
  end
  request {(((B.$V).s).1)=0}((B.$V).s) do
    from {{}(B.$V)=valof ((B.$V).1)} do
      valof {((B.$V).1)=0}(B.$V) is
        output 0 : output output 0
      end
    end
  end
  request {(((B.$V).s).1)=1}((B.$V).s) do
    from {{}(B.$V)=valof ((B.$V).1)} do
      valof {((B.$V).1)=1}(B.$V) is
        valof ((B.$V).2) : output valof (((B.$V).s).2)
      end
    end
  end
  request {(((B.$V).s).1)=1,(((B.$V).s).2)=0}((B.$V).s) do
    from {{}(B.$V)=valof ((B.$V).1),{((B.$V).1)=1}(B.$V)=valof ((B.$V).2)} do
      valof {((B.$V).1)=1,((B.$V).2)=0}(B.$V) is
        output 0 : output output 0
      end
    end
  end
  request {(((B.$V).s).1)=1,(((B.$V).s).2)=1}((B.$V).s) do
    from {{}(B.$V)=valof ((B.$V).1),{((B.$V).1)=1}(B.$V)=valof ((B.$V).2)} do
      valof {((B.$V).1)=1,((B.$V).2)=1}(B.$V) is
        output 1 : output output 1
      end
    end
  end
end;

let left_min = fix(left_min_rec);
