(* Examples from Curien's book *)


  (* Some type definitions *)

let BOOL = dcds cell B values tt,ff end;

let INT =
  dcds
    cell N values [..]
  end;

let FRACTIONS =
  dcds
    cell R values ([..].[1..])
  end;

letrec STREAMS =
  dcds
    cell (N.1) values [..]
    graft (STREAMS.2) access (N.1)=[..]
  end;

letrec INT_LIST =
  dcds
    cell SEL values L,R
    graft ((INT.1).R) access SEL=R
    graft ((INT_LIST.2).R) access SEL=R
  end;

let SERIES =
  dcds
    cell (R.[0..]) values ([..].[1..])
  end;

let AND_TYPE =
  dcds
    cell WHICH_AND values IS_LEFT_AND, IS_LEFT_STRICT_AND,
                          IS_RIGHT_AND, IS_RIGHT_STRICT_AND,
                          IS_NOT_AN_AND
  end;


  (* Algorithm definitions *)

let NOT =
algo
  request B do
    valof B is
      tt : output ff
      ff : output tt
    end
  end
end;

let LEFT_AND =
  algo
    request B do
      valof (B.1) is
        tt: valof (B.2) is
              tt: output tt
              ff: output ff
            end
        ff: output ff
      end
    end
  end;

let LEFT_STRICT_AND =
  algo
    request B do
      valof (B.1) is
        tt: valof (B.2) is
              tt: output tt
              ff: output ff
            end
        ff: valof (B.2) is
              tt: output ff
              ff: output ff
            end
      end
    end
  end;

let CURRY_LEFT_AND =
algo
  request {}B do
    valof B is
      tt: output valof B
      ff: output output ff
    end
  end
  request {B=tt}B do
    from {B=tt} do
      output output tt
    end
  end
  request {B=ff}B do
    from {B=tt} do
      output output ff
    end
  end
end;

let RIGHT_AND =
algo
  request B do
    valof (B.2) is
      tt: valof (B.1) is
            tt: output tt
            ff: output ff
          end
      ff: output ff
    end
  end
end;

let RIGHT_STRICT_AND =
algo
  request B do
    valof (B.2) is
      tt: valof (B.1) is
            tt: output tt
            ff: output ff
          end
      ff: valof (B.1) is
            tt: output ff
            ff: output ff
          end
    end
  end
end;

let AND_TASTER =
  algo
    request WHICH_AND do
      valof {}B is
	output tt: output IS_NOT_AN_AND
	output ff: output IS_NOT_AN_AND
	valof (B.1): 
	  valof {(B.1)=tt}B is
	    output tt: output IS_NOT_AN_AND
	    output ff: output IS_NOT_AN_AND
	    valof (B.2):
	      valof {(B.1)=tt,(B.2)=tt}B is
	      	output ff: output IS_NOT_AN_AND
		output tt:
		  valof {(B.1)=tt,(B.2)=ff}B is
		    output tt: output IS_NOT_AN_AND
		    output ff:
		      valof {(B.1)=ff}B is
			output tt: output IS_NOT_AN_AND
			output ff: output IS_LEFT_AND
			valof (B.2):
			  valof {(B.1)=ff,(B.2)=tt}B is
		    	    output tt: output IS_NOT_AN_AND
			    output ff:
			      valof {(B.1)=ff,(B.2)=ff}B is
		    	      	output tt: output IS_NOT_AN_AND
				output ff: output IS_LEFT_STRICT_AND
			      end
			  end
		      end
		  end
		end
	  end
	valof (B.2): 
	  valof {(B.2)=tt}B is
	    output tt: output IS_NOT_AN_AND
	    output ff: output IS_NOT_AN_AND
	    valof (B.1):
	      valof {(B.2)=tt,(B.1)=tt}B is
	      	output ff: output IS_NOT_AN_AND
		output tt:
		  valof {(B.2)=tt,(B.1)=ff}B is
		    output tt: output IS_NOT_AN_AND
		    output ff:
		      valof {(B.2)=ff}B is
			output tt: output IS_NOT_AN_AND
			output ff: output IS_RIGHT_AND
			valof (B.1):
			  valof {(B.2)=ff,(B.1)=tt}B is
		    	    output tt: output IS_NOT_AN_AND
			    output ff:
			      valof {(B.2)=ff,(B.1)=ff}B is
		    	      	output tt: output IS_NOT_AN_AND
				output ff: output IS_RIGHT_STRICT_AND
			      end
			  end
		      end
		  end
		end
	  end
      end
    end
  end;

let ID = algo
    request $C do
   	valof $C is
	    $V : output $V
	end
    end
end;

let FST = algo
    request $C do
    	valof ($C.1) is
	    $V: output $V
    	end
    end
end;

let LEFT_ADD = algo
    request N do
	valof (N.1) is
	    $V1: valof (N.2) is
		  $V2: output $V1 + $V2
		 end
	end
    end
end;

let EXP = uncurry(ID) | <ID, curry(FST).{(B.1)=ff}>;

let ffibo = algo
    request {}N do
	output valof N
    end
    request {N=$V with ($V=1) or ($V=2)}N do
	output output 1
    end
    request {N=$V with $V>2}N do
	valof {}N is
	    output $X: output output $X+$X
	    valof N: valof {N=$V-1}N is
		      output $X: valof {N=$V-2}N is
				  output $Y: output output $X+$Y
				 end
		     end
	end
    end
end;

let fibo = fix(ffibo);

let INTEGRATION = algo
    request (R.0) do
	valof (R.1) is
	    ($P.$Q): output ($P.$Q)
	end
    end
    request (R.$N) with ($N>0) do
	valof ((R.$N-1).2) is
	    ($P.$Q): output ($P.$Q*$N)
	end
    end
end;

let INTEGRATE = curry(INTEGRATION);

let E = fix(INTEGRATE.{R=(1.1)});

let MINUS = algo
    request $C do
	valof $C is
	    ($V.$W): output (~$V.$W)
	end
    end
end;

let SIN = fix((INTEGRATE.{R=(0.1)}) | ((INTEGRATE.{R=(1.1)}) | MINUS));
