(* Andtaster with refinement types.
   Gives rise to a very detailed refinement type for the algorithm *)


let and_type =
  dcds
    cell WHICH_AND values IS_LEFT_AND, IS_LEFT_STRICT_AND,
                          IS_RIGHT_AND, IS_RIGHT_STRICT_AND,
                          IS_NOT_AN_AND
  end;

let is_and_type =
  dcds 
    cell WHICH_AND values IS_LEFT_AND, IS_LEFT_STRICT_AND,
                          IS_RIGHT_AND, IS_RIGHT_STRICT_AND
  end;

let is_not_and_type =
  dcds 
    cell WHICH_AND values IS_NOT_AN_AND
  end;

refine is_and_type, is_not_and_type;


let AND_TASTER =
  algo
    request WHICH_AND do
      valof {}B is
	output tt: output IS_NOT_AN_AND
	output ff: output IS_NOT_AN_AND
	valof (B.1): 
	  valof {(B.1)=tt}B is
	    output tt: output IS_NOT_AN_AND
	    output ff: output IS_NOT_AN_AND
	    valof (B.2):
	      valof {(B.1)=tt,(B.2)=tt}B is
	      	output ff: output IS_NOT_AN_AND
		output tt:
		  valof {(B.1)=tt,(B.2)=ff}B is
		    output tt: output IS_NOT_AN_AND
		    output ff:
		      valof {(B.1)=ff}B is
			output tt: output IS_NOT_AN_AND
			output ff: output IS_LEFT_AND
			valof (B.2):
			  valof {(B.1)=ff,(B.2)=tt}B is
		    	    output tt: output IS_NOT_AN_AND
			    output ff:
			      valof {(B.1)=ff,(B.2)=ff}B is
		    	      	output tt: output IS_NOT_AN_AND
				output ff: output IS_LEFT_STRICT_AND
			      end
			  end
		      end
		  end
		end
	  end
	valof (B.2): 
	  valof {(B.2)=tt}B is
	    output tt: output IS_NOT_AN_AND
	    output ff: output IS_NOT_AN_AND
	    valof (B.1):
	      valof {(B.2)=tt,(B.1)=tt}B is
	      	output ff: output IS_NOT_AN_AND
		output tt:
		  valof {(B.2)=tt,(B.1)=ff}B is
		    output tt: output IS_NOT_AN_AND
		    output ff:
		      valof {(B.2)=ff}B is
			output tt: output IS_NOT_AN_AND
			output ff: output IS_RIGHT_AND
			valof (B.1):
			  valof {(B.2)=ff,(B.1)=tt}B is
		    	    output tt: output IS_NOT_AN_AND
			    output ff:
			      valof {(B.2)=ff,(B.1)=ff}B is
		    	      	output tt: output IS_NOT_AN_AND
				output ff: output IS_RIGHT_STRICT_AND
			      end
			  end
		      end
		  end
		end
	  end
      end
    end
  end;
