(* Examples of abstract interpretation in CDS0 *)

(* -------------------------- BOOLEANS ---------------------------- *)

let bool = dcds cell B values tt,ff end;

(* The "refined" types *)

let true = dcds cell B values tt end;
let false = dcds cell B values ff end;

refine true, false;



(* cond : ((bool * 'a) * 'a) -> 'a  *)
let cond = 
  algo
    request $C do
      valof ((B.1).1) is
        tt: valof (($C.2).1) is
              $V: output $V
            end
        ff: valof ($C.2) is
              $W: output $W
            end
      end
    end
  end;

let not = algo
  request B do
    valof B is
      tt : output ff
      ff : output tt
    end
  end
end;

(* and : (bool * bool) -> bool  *)
let land =
  algo
    request B do
      valof (B.1) is
        tt: valof (B.2) is
              tt: output tt
              ff: output ff
            end
        ff: output ff
      end
    end
  end;

let lor =
  algo
    request B do
      valof (B.1) is
        tt: output tt
	ff: valof (B.2) is
              tt: output tt
              ff: output ff
            end
      end
    end
  end;


(* --------------------------- LISTS ------------------------------ *)

let int = dcds cell N values [..] end;

letrec intlist = dcds 
  cell EMPTY values true, false
  graft (int.l) access EMPTY = false
  graft (intlist.l) access EMPTY=false
end;

(* refined types *)

let empty_intlist = dcds
  cell EMPTY values true
end;

let one_intlist = dcds
  cell EMPTY values false
  cell (N.l) values [..] access EMPTY = false
  cell (EMPTY.l) values true access EMPTY = false
end;

local letrec partial_intlist = dcds
  cell (EMPTY.l) values true, false access EMPTY = false
  cell (N.l) values [..] access EMPTY = false
  graft (partial_intlist.l) access EMPTY = false
  end
in let many_intlist = dcds
  cell EMPTY values false
  cell (N.l) values [..] access EMPTY = false
  cell (EMPTY.l) values false access EMPTY = false
  cell ((N.l).l) values [..] access (EMPTY.l) = false
  graft (partial_intlist.l)
  end
end;

refine empty_intlist, one_intlist, many_intlist;


let nil = {EMPTY = true};

let null = algo
  request B do
    valof EMPTY is
      true : output tt
      false : output ff
    end
  end
end;

let cons = algo
  request EMPTY do
    output false
  end
  request (N.l) do
    valof (N.1) is 
      $V : output $V
    end
  end
  request (EMPTY.l) do
    valof (EMPTY.2) is
      $B : output $B
    end
  end
  request (((EMPTY.$T).l).l) do
    from {((EMPTY.$T).2)=false} do
      valof (((EMPTY.$T).l).2) is
        $B : output $B
      end
    end
  end
  request (((N.$T).l).l) do
    from {((EMPTY.$T).2)=false} do
      valof (((N.$T).l).2) is
	$V : output $V
      end
    end
  end
end;


let hd = algo
  request N do
    valof EMPTY is
      false : valof (N.l) is
                $V : output $V
	      end
    end
  end
end;


let tl = algo
  request (EMPTY.$T) do
    from {(EMPTY.$T)=false} do
      valof ((EMPTY.$T).l) is
        $B : output $B
      end
    end
  end
  request ((N.$T).l) do
    from {(EMPTY.$T)=false, ((EMPTY.$T).l)=false} do
      valof (((N.$T).l).l) is
        $V : output $V
      end
    end
  end
end;


(* ---------------------- NATURAL NUMBERS ------------------------- *)

let nat = dcds cell NAT values [0..] end;

(* The "refined" types *)

let zero = dcds cell NAT values 0 end;
let pos = dcds cell NAT values [1..] end;

refine zero, pos;


(* Refinement type inference does not get good types here,
   because it needs to deduce things about integer arithmetic.
   This can be added to the implementation. *)

let iszero = algo
    request B do
        valof NAT is
            0: output tt
            $V with $V > 0: output ff
        end
    end
end;

let succ = algo
    request NAT do
        valof NAT is
            $V: output $V + 1
        end
    end
end;

let pred = algo
    request NAT do
        valof NAT is
            $V with $V <= 0 : output 0
            $V with $V > 0  : output $V - 1
        end
    end
end;

let plus = algo
    request NAT do
	valof (NAT.1) is
	    $V1: valof (NAT.2) is
		  $V2: output $V1 + $V2
		 end
	end
    end
end;
