functor PCFLrValsFun (structure Token : TOKEN) : PCF_LRVALS = 
struct
structure ParserData=
struct
structure Header = 
struct
(* Parser definition for PCF-like language: a typed lamda calculus
   with constants, couples, projections, integer lists, and fixpoints.
   For easy reference, the definition is:

program ::= expr
          | val ident = expr
          | load file
          | print ident

expr ::= const
       | ident
       | expr expr
       | fn ident => expr
       | let ident = expr in expr end
       | letrec ident = expr in expr end
       | expr op expr
       | if expr then expr else expr
       | (expr, expr)
       | fst (expr)
       | snd (expr)
       | expr :: expr      (* list stuff --- new *)
       | hd expr
       | tl expr
       | []
       | null expr
       | (expr)

const ::= true | false | int

op ::= + | - | * | / | = | < | > | <= | >= | and | or      *)


open PCFBasic


end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\001\000\025\000\002\000\024\000\003\000\080\000\005\000\038\000\
\\007\000\022\000\009\000\037\000\010\000\036\000\011\000\021\000\
\\014\000\035\000\015\000\034\000\016\000\020\000\018\000\033\000\
\\019\000\032\000\022\000\031\000\023\000\030\000\024\000\029\000\
\\025\000\028\000\026\000\017\000\028\000\016\000\030\000\015\000\
\\033\000\014\000\034\000\013\000\035\000\012\000\036\000\011\000\
\\038\000\027\000\039\000\009\000\040\000\008\000\041\000\007\000\
\\042\000\006\000\000\000\
\\001\000\001\000\025\000\002\000\024\000\003\000\081\000\005\000\038\000\
\\007\000\022\000\009\000\037\000\010\000\036\000\011\000\021\000\
\\014\000\035\000\015\000\034\000\016\000\020\000\018\000\033\000\
\\019\000\032\000\022\000\031\000\023\000\030\000\024\000\029\000\
\\025\000\028\000\026\000\017\000\028\000\016\000\030\000\015\000\
\\033\000\014\000\034\000\013\000\035\000\012\000\036\000\011\000\
\\038\000\027\000\039\000\009\000\040\000\008\000\041\000\007\000\
\\042\000\006\000\000\000\
\\001\000\001\000\025\000\002\000\024\000\005\000\038\000\006\000\085\000\
\\007\000\022\000\009\000\037\000\010\000\036\000\011\000\021\000\
\\014\000\035\000\015\000\034\000\016\000\020\000\018\000\033\000\
\\019\000\032\000\022\000\031\000\023\000\030\000\024\000\029\000\
\\025\000\028\000\026\000\017\000\028\000\016\000\030\000\015\000\
\\033\000\014\000\034\000\013\000\035\000\012\000\036\000\011\000\
\\038\000\027\000\039\000\009\000\040\000\008\000\041\000\007\000\
\\042\000\006\000\000\000\
\\001\000\001\000\025\000\002\000\024\000\005\000\038\000\006\000\086\000\
\\007\000\022\000\009\000\037\000\010\000\036\000\011\000\021\000\
\\014\000\035\000\015\000\034\000\016\000\020\000\018\000\033\000\
\\019\000\032\000\022\000\031\000\023\000\030\000\024\000\029\000\
\\025\000\028\000\026\000\017\000\028\000\016\000\030\000\015\000\
\\033\000\014\000\034\000\013\000\035\000\012\000\036\000\011\000\
\\038\000\027\000\039\000\009\000\040\000\008\000\041\000\007\000\
\\042\000\006\000\000\000\
\\001\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\008\000\068\000\009\000\037\000\010\000\036\000\011\000\021\000\
\\014\000\035\000\015\000\034\000\016\000\020\000\017\000\067\000\
\\018\000\033\000\019\000\032\000\022\000\031\000\023\000\030\000\
\\024\000\029\000\025\000\028\000\026\000\017\000\028\000\016\000\
\\030\000\015\000\033\000\014\000\034\000\013\000\035\000\012\000\
\\036\000\011\000\038\000\027\000\039\000\009\000\040\000\008\000\
\\041\000\007\000\042\000\006\000\000\000\
\\001\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\017\000\079\000\018\000\033\000\
\\019\000\032\000\022\000\031\000\023\000\030\000\024\000\029\000\
\\025\000\028\000\026\000\017\000\028\000\016\000\030\000\015\000\
\\033\000\014\000\034\000\013\000\035\000\012\000\036\000\011\000\
\\038\000\027\000\039\000\009\000\040\000\008\000\041\000\007\000\
\\042\000\006\000\000\000\
\\001\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\022\000\031\000\023\000\030\000\024\000\029\000\025\000\028\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\031\000\065\000\
\\033\000\014\000\034\000\013\000\035\000\012\000\036\000\011\000\
\\038\000\027\000\039\000\009\000\040\000\008\000\041\000\007\000\
\\042\000\006\000\000\000\
\\001\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\022\000\031\000\023\000\030\000\024\000\029\000\025\000\028\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\032\000\078\000\
\\033\000\014\000\034\000\013\000\035\000\012\000\036\000\011\000\
\\038\000\027\000\039\000\009\000\040\000\008\000\041\000\007\000\
\\042\000\006\000\000\000\
\\001\000\001\000\025\000\002\000\024\000\007\000\022\000\011\000\021\000\
\\016\000\020\000\026\000\017\000\028\000\016\000\030\000\015\000\
\\033\000\014\000\034\000\013\000\035\000\012\000\036\000\011\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\001\000\005\000\069\000\000\000\
\\001\000\005\000\070\000\000\000\
\\001\000\005\000\071\000\000\000\
\\001\000\007\000\046\000\000\000\
\\001\000\011\000\045\000\000\000\
\\001\000\011\000\047\000\000\000\
\\001\000\011\000\050\000\000\000\
\\001\000\011\000\051\000\000\000\
\\001\000\011\000\052\000\000\000\
\\001\000\012\000\000\000\013\000\000\000\000\000\
\\001\000\027\000\048\000\000\000\
\\001\000\029\000\066\000\000\000\
\\088\000\001\000\025\000\002\000\024\000\004\000\023\000\007\000\022\000\
\\011\000\021\000\016\000\020\000\020\000\019\000\021\000\018\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\033\000\014\000\
\\034\000\013\000\035\000\012\000\036\000\011\000\037\000\010\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\089\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\022\000\031\000\023\000\030\000\024\000\029\000\025\000\028\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\033\000\014\000\
\\034\000\013\000\035\000\012\000\036\000\011\000\038\000\027\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\090\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\022\000\031\000\023\000\030\000\024\000\029\000\025\000\028\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\033\000\014\000\
\\034\000\013\000\035\000\012\000\036\000\011\000\038\000\027\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\091\000\000\000\
\\092\000\000\000\
\\093\000\000\000\
\\094\000\000\000\
\\095\000\000\000\
\\096\000\000\000\
\\097\000\000\000\
\\098\000\001\000\025\000\002\000\024\000\007\000\022\000\011\000\021\000\
\\016\000\020\000\026\000\017\000\028\000\016\000\030\000\015\000\
\\033\000\014\000\034\000\013\000\035\000\012\000\036\000\011\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\099\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\022\000\031\000\023\000\030\000\024\000\029\000\025\000\028\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\033\000\014\000\
\\034\000\013\000\035\000\012\000\036\000\011\000\038\000\027\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\100\000\000\000\
\\101\000\000\000\
\\102\000\000\000\
\\103\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\022\000\031\000\023\000\030\000\024\000\029\000\025\000\028\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\033\000\014\000\
\\034\000\013\000\035\000\012\000\036\000\011\000\038\000\027\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\104\000\000\000\
\\105\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\022\000\031\000\023\000\030\000\024\000\029\000\025\000\028\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\033\000\014\000\
\\034\000\013\000\035\000\012\000\036\000\011\000\038\000\027\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\106\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\022\000\031\000\023\000\030\000\024\000\029\000\025\000\028\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\033\000\014\000\
\\034\000\013\000\035\000\012\000\036\000\011\000\038\000\027\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\107\000\001\000\025\000\002\000\024\000\007\000\022\000\011\000\021\000\
\\016\000\020\000\026\000\017\000\028\000\016\000\030\000\015\000\
\\033\000\014\000\034\000\013\000\035\000\012\000\036\000\011\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\108\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\022\000\031\000\023\000\030\000\024\000\029\000\025\000\028\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\033\000\014\000\
\\034\000\013\000\035\000\012\000\036\000\011\000\038\000\027\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\109\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\022\000\031\000\023\000\030\000\024\000\029\000\025\000\028\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\033\000\014\000\
\\034\000\013\000\035\000\012\000\036\000\011\000\038\000\027\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\110\000\000\000\
\\111\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\022\000\031\000\023\000\030\000\024\000\029\000\025\000\028\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\033\000\014\000\
\\034\000\013\000\035\000\012\000\036\000\011\000\038\000\027\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\112\000\000\000\
\\113\000\000\000\
\\114\000\000\000\
\\115\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\024\000\029\000\025\000\028\000\026\000\017\000\028\000\016\000\
\\030\000\015\000\033\000\014\000\034\000\013\000\035\000\012\000\
\\036\000\011\000\038\000\027\000\039\000\009\000\040\000\008\000\
\\041\000\007\000\042\000\006\000\000\000\
\\116\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\024\000\029\000\025\000\028\000\026\000\017\000\028\000\016\000\
\\030\000\015\000\033\000\014\000\034\000\013\000\035\000\012\000\
\\036\000\011\000\038\000\027\000\039\000\009\000\040\000\008\000\
\\041\000\007\000\042\000\006\000\000\000\
\\117\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\033\000\014\000\
\\034\000\013\000\035\000\012\000\036\000\011\000\038\000\027\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\118\000\001\000\025\000\002\000\024\000\005\000\038\000\007\000\022\000\
\\009\000\037\000\010\000\036\000\011\000\021\000\014\000\035\000\
\\015\000\034\000\016\000\020\000\018\000\033\000\019\000\032\000\
\\026\000\017\000\028\000\016\000\030\000\015\000\033\000\014\000\
\\034\000\013\000\035\000\012\000\036\000\011\000\038\000\027\000\
\\039\000\009\000\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\119\000\001\000\025\000\002\000\024\000\007\000\022\000\009\000\037\000\
\\010\000\036\000\011\000\021\000\016\000\020\000\026\000\017\000\
\\028\000\016\000\030\000\015\000\033\000\014\000\034\000\013\000\
\\035\000\012\000\036\000\011\000\038\000\027\000\039\000\009\000\
\\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\120\000\001\000\025\000\002\000\024\000\007\000\022\000\009\000\037\000\
\\010\000\036\000\011\000\021\000\016\000\020\000\026\000\017\000\
\\028\000\016\000\030\000\015\000\033\000\014\000\034\000\013\000\
\\035\000\012\000\036\000\011\000\038\000\027\000\039\000\009\000\
\\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\121\000\001\000\025\000\002\000\024\000\007\000\022\000\009\000\037\000\
\\010\000\036\000\011\000\021\000\016\000\020\000\026\000\017\000\
\\028\000\016\000\030\000\015\000\033\000\014\000\034\000\013\000\
\\035\000\012\000\036\000\011\000\038\000\027\000\039\000\009\000\
\\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\122\000\001\000\025\000\002\000\024\000\007\000\022\000\009\000\037\000\
\\010\000\036\000\011\000\021\000\016\000\020\000\026\000\017\000\
\\028\000\016\000\030\000\015\000\033\000\014\000\034\000\013\000\
\\035\000\012\000\036\000\011\000\038\000\027\000\039\000\009\000\
\\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\123\000\001\000\025\000\002\000\024\000\007\000\022\000\009\000\037\000\
\\010\000\036\000\011\000\021\000\016\000\020\000\026\000\017\000\
\\028\000\016\000\030\000\015\000\033\000\014\000\034\000\013\000\
\\035\000\012\000\036\000\011\000\038\000\027\000\039\000\009\000\
\\040\000\008\000\041\000\007\000\042\000\006\000\000\000\
\\124\000\001\000\025\000\002\000\024\000\007\000\022\000\011\000\021\000\
\\016\000\020\000\026\000\017\000\028\000\016\000\030\000\015\000\
\\033\000\014\000\034\000\013\000\035\000\012\000\036\000\011\000\
\\038\000\027\000\039\000\009\000\040\000\008\000\041\000\007\000\
\\042\000\006\000\000\000\
\\125\000\001\000\025\000\002\000\024\000\007\000\022\000\011\000\021\000\
\\016\000\020\000\026\000\017\000\028\000\016\000\030\000\015\000\
\\033\000\014\000\034\000\013\000\035\000\012\000\036\000\011\000\
\\038\000\027\000\039\000\009\000\040\000\008\000\041\000\007\000\
\\042\000\006\000\000\000\
\"
val actionRowNumbers =
"\021\000\029\000\035\000\022\000\
\\008\000\043\000\008\000\008\000\
\\026\000\028\000\027\000\008\000\
\\008\000\008\000\013\000\012\000\
\\014\000\019\000\008\000\030\000\
\\046\000\015\000\016\000\017\000\
\\031\000\008\000\008\000\008\000\
\\008\000\008\000\008\000\008\000\
\\008\000\008\000\008\000\008\000\
\\008\000\044\000\042\000\041\000\
\\039\000\038\000\006\000\020\000\
\\047\000\025\000\024\000\004\000\
\\009\000\010\000\011\000\040\000\
\\051\000\050\000\049\000\048\000\
\\056\000\055\000\054\000\053\000\
\\057\000\058\000\052\000\008\000\
\\008\000\045\000\008\000\008\000\
\\008\000\008\000\007\000\032\000\
\\005\000\023\000\000\000\001\000\
\\008\000\037\000\008\000\008\000\
\\036\000\002\000\003\000\034\000\
\\033\000\018\000"
val gotoT =
"\
\\001\000\085\000\002\000\003\000\003\000\002\000\004\000\001\000\000\000\
\\000\000\
\\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\037\000\003\000\002\000\004\000\001\000\000\000\
\\000\000\
\\002\000\038\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\039\000\003\000\002\000\004\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\040\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\041\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\042\000\003\000\002\000\004\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\047\000\003\000\002\000\004\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\051\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\052\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\053\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\054\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\055\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\056\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\057\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\058\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\059\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\060\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\061\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\062\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\070\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\071\000\003\000\002\000\004\000\001\000\000\000\
\\000\000\
\\002\000\072\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\073\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\074\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\075\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\080\000\003\000\002\000\004\000\001\000\000\000\
\\000\000\
\\002\000\081\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\082\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\002\000\024\000\003\000\002\000\004\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 86
val numrules = 38
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; ordof(!s,i) + ordof(!s,i+1) * 256
end
val string_to_list = fn s' =>
    let val len = String.length s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.length s'
 	 fun f ()=
	    if !index < len then convert_row() :: f()
	    else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
	fun f i =
	     if i=numstates then g i
	     else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
	   in f 0 handle Subscript => ()
	   end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.arrayoflist(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.arrayoflist(actionRows) in fn i=>Array.sub(a,i) end
in Array.arrayoflist(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = int
type arg = unit
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit | FILE of  (string)
 | ID of  (string) | INTEGER of  (int) | int of  (int)
 | bop of  (PCF_Boperation) | expr of  (PCF_Expr)
 | program of  (PCF_ParseTree)
end
type svalue = MlyValue.svalue
type result = PCF_ParseTree
end
structure EC=
struct
open LrTable
val is_keyword =
fn (T 39) => true | (T 38) => true | (T 41) => true | (T 36) => true
 | (T 35) => true | (T 34) => true | (T 27) => true | (T 33) => true
 | (T 32) => true | (T 31) => true | (T 30) => true | (T 29) => true
 | (T 20) => true | (T 19) => true | (T 5) => true | (T 2) => true | 
(T 3) => true | (T 1) => true | (T 0) => true | _ => false
val preferred_insert =
fn _ => false
val preferred_subst =
fn  _ => nil
val noShift = 
fn (T 11) => true | _ => false
val showTerminal =
fn (T 0) => "LET"
  | (T 1) => "LETREC"
  | (T 2) => "IN"
  | (T 3) => "VAL"
  | (T 4) => "EQ"
  | (T 5) => "END"
  | (T 6) => "INTEGER"
  | (T 7) => "COMMA"
  | (T 8) => "OR"
  | (T 9) => "AND"
  | (T 10) => "ID"
  | (T 11) => "EOF"
  | (T 12) => "SEMI"
  | (T 13) => "LA"
  | (T 14) => "RA"
  | (T 15) => "LB"
  | (T 16) => "RB"
  | (T 17) => "LEQ"
  | (T 18) => "GEQ"
  | (T 19) => "LOAD"
  | (T 20) => "PRINT"
  | (T 21) => "PLUS"
  | (T 22) => "SUB"
  | (T 23) => "MULT"
  | (T 24) => "DIV"
  | (T 25) => "MINUS"
  | (T 26) => "FILE"
  | (T 27) => "FN"
  | (T 28) => "MAPSTO"
  | (T 29) => "IF"
  | (T 30) => "THEN"
  | (T 31) => "ELSE"
  | (T 32) => "FST"
  | (T 33) => "SND"
  | (T 34) => "TRUE"
  | (T 35) => "FALSE"
  | (T 36) => "QUIT"
  | (T 37) => "CONS"
  | (T 38) => "HD"
  | (T 39) => "TL"
  | (T 40) => "NIL"
  | (T 41) => "NULL"
  | _ => "bogus-term"
val errtermvalue=
let open Header in
fn _ => MlyValue.VOID
end
val terms = (T 0) :: (T 1) :: (T 2) :: (T 3) :: (T 4) :: (T 5) :: (T 7
) :: (T 8) :: (T 9) :: (T 11) :: (T 12) :: (T 13) :: (T 14) :: (T 15)
 :: (T 16) :: (T 17) :: (T 18) :: (T 19) :: (T 20) :: (T 21) :: (T 22)
 :: (T 23) :: (T 24) :: (T 25) :: (T 27) :: (T 28) :: (T 29) :: (T 30)
 :: (T 31) :: (T 32) :: (T 33) :: (T 34) :: (T 35) :: (T 36) :: (T 37)
 :: (T 38) :: (T 39) :: (T 40) :: (T 41) :: nil
end
structure Actions =
struct 
exception mlyAction of int
val actions = 
let open Header
in
fn (i392,defaultPos,stack,
    (()):arg) =>
case (i392,stack)
of (0,rest671) => let val result=MlyValue.program((PCF_Empty))
 in (LrTable.NT 0,(result,defaultPos,defaultPos),rest671) end
| (1,(_,(MlyValue.expr expr,expr1left,expr1right))::rest671) => let 
val result=MlyValue.program((PCF_Exp expr))
 in (LrTable.NT 0,(result,expr1left,expr1right),rest671) end
| (2,(_,(MlyValue.expr expr,_,expr1right))::_::(_,(MlyValue.ID ID,_,_)
)::(_,(_,VAL1left,_))::rest671) => let val result=MlyValue.program((
PCF_Val(ID,expr)))
 in (LrTable.NT 0,(result,VAL1left,expr1right),rest671) end
| (3,(_,(MlyValue.FILE FILE,_,FILE1right))::(_,(_,LOAD1left,_))::
rest671) => let val result=MlyValue.program((PCF_Load FILE))
 in (LrTable.NT 0,(result,LOAD1left,FILE1right),rest671) end
| (4,(_,(MlyValue.ID ID,_,ID1right))::(_,(_,PRINT1left,_))::rest671)
 => let val result=MlyValue.program((PCF_Print ID))
 in (LrTable.NT 0,(result,PRINT1left,ID1right),rest671) end
| (5,(_,(_,QUIT1left,QUIT1right))::rest671) => let val result=
MlyValue.program((PCF_Quit))
 in (LrTable.NT 0,(result,QUIT1left,QUIT1right),rest671) end
| (6,(_,(_,TRUE1left,TRUE1right))::rest671) => let val result=
MlyValue.expr((pcf_Bool true))
 in (LrTable.NT 1,(result,TRUE1left,TRUE1right),rest671) end
| (7,(_,(_,FALSE1left,FALSE1right))::rest671) => let val result=
MlyValue.expr((pcf_Bool false))
 in (LrTable.NT 1,(result,FALSE1left,FALSE1right),rest671) end
| (8,(_,(MlyValue.int int,int1left,int1right))::rest671) => let val 
result=MlyValue.expr((pcf_Int int))
 in (LrTable.NT 1,(result,int1left,int1right),rest671) end
| (9,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val result
=MlyValue.expr((pcf_Ident ID))
 in (LrTable.NT 1,(result,ID1left,ID1right),rest671) end
| (10,(_,(MlyValue.expr expr2,_,expr2right))::(_,(MlyValue.expr expr1,
expr1left,_))::rest671) => let val result=MlyValue.expr((
pcf_App(expr1, expr2)))
 in (LrTable.NT 1,(result,expr1left,expr2right),rest671) end
| (11,(_,(MlyValue.expr expr,_,expr1right))::_::(_,(MlyValue.ID ID,_,_
))::(_,(_,FN1left,_))::rest671) => let val result=MlyValue.expr((
pcf_Lam(ID, expr)))
 in (LrTable.NT 1,(result,FN1left,expr1right),rest671) end
| (12,(_,(_,_,END1right))::(_,(MlyValue.expr expr2,_,_))::_::(_,(
MlyValue.expr expr1,_,_))::_::(_,(MlyValue.ID ID,_,_))::(_,(_,LET1left
,_))::rest671) => let val result=MlyValue.expr((
pcf_Let(ID, expr1, expr2)))
 in (LrTable.NT 1,(result,LET1left,END1right),rest671) end
| (13,(_,(_,_,END1right))::(_,(MlyValue.expr expr2,_,_))::_::(_,(
MlyValue.expr expr1,_,_))::_::(_,(MlyValue.ID ID,_,_))::(_,(_,
LETREC1left,_))::rest671) => let val result=MlyValue.expr((
pcf_Letrec(ID, expr1, expr2)))
 in (LrTable.NT 1,(result,LETREC1left,END1right),rest671) end
| (14,(_,(MlyValue.bop bop,bop1left,bop1right))::rest671) => let val 
result=MlyValue.expr((pcf_Bop bop))
 in (LrTable.NT 1,(result,bop1left,bop1right),rest671) end
| (15,(_,(MlyValue.expr expr3,_,expr3right))::_::(_,(MlyValue.expr 
expr2,_,_))::_::(_,(MlyValue.expr expr1,_,_))::(_,(_,IF1left,_))::
rest671) => let val result=MlyValue.expr((
pcf_Cond(expr1, expr2, expr3)))
 in (LrTable.NT 1,(result,IF1left,expr3right),rest671) end
| (16,(_,(_,_,RB1right))::(_,(MlyValue.expr expr2,_,_))::_::(_,(
MlyValue.expr expr1,_,_))::(_,(_,LB1left,_))::rest671) => let val 
result=MlyValue.expr((pcf_Couple(expr1, expr2)))
 in (LrTable.NT 1,(result,LB1left,RB1right),rest671) end
| (17,(_,(MlyValue.expr expr,_,expr1right))::(_,(_,FST1left,_))::
rest671) => let val result=MlyValue.expr((pcf_Fst expr))
 in (LrTable.NT 1,(result,FST1left,expr1right),rest671) end
| (18,(_,(MlyValue.expr expr,_,expr1right))::(_,(_,SND1left,_))::
rest671) => let val result=MlyValue.expr((pcf_Snd expr))
 in (LrTable.NT 1,(result,SND1left,expr1right),rest671) end
| (19,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.expr((
pcf_Cons(expr1,expr2)))
 in (LrTable.NT 1,(result,expr1left,expr2right),rest671) end
| (20,(_,(MlyValue.expr expr,_,expr1right))::(_,(_,HD1left,_))::
rest671) => let val result=MlyValue.expr((pcf_Head expr))
 in (LrTable.NT 1,(result,HD1left,expr1right),rest671) end
| (21,(_,(MlyValue.expr expr,_,expr1right))::(_,(_,TL1left,_))::
rest671) => let val result=MlyValue.expr((pcf_Tail expr))
 in (LrTable.NT 1,(result,TL1left,expr1right),rest671) end
| (22,(_,(_,NIL1left,NIL1right))::rest671) => let val result=
MlyValue.expr((pcf_Nil))
 in (LrTable.NT 1,(result,NIL1left,NIL1right),rest671) end
| (23,(_,(MlyValue.expr expr,_,expr1right))::(_,(_,NULL1left,_))::
rest671) => let val result=MlyValue.expr((pcf_Null expr))
 in (LrTable.NT 1,(result,NULL1left,expr1right),rest671) end
| (24,(_,(_,_,RB1right))::(_,(MlyValue.expr expr,_,_))::(_,(_,LB1left,
_))::rest671) => let val result=MlyValue.expr((expr))
 in (LrTable.NT 1,(result,LB1left,RB1right),rest671) end
| (25,(_,(MlyValue.INTEGER INTEGER,INTEGER1left,INTEGER1right))::
rest671) => let val result=MlyValue.int((INTEGER))
 in (LrTable.NT 3,(result,INTEGER1left,INTEGER1right),rest671) end
| (26,(_,(MlyValue.INTEGER INTEGER,_,INTEGER1right))::(_,(_,MINUS1left
,_))::rest671) => let val result=MlyValue.int((~INTEGER))
 in (LrTable.NT 3,(result,MINUS1left,INTEGER1right),rest671) end
| (27,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.bop((
pcf_Plus(expr1, expr2)))
 in (LrTable.NT 2,(result,expr1left,expr2right),rest671) end
| (28,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.bop((
pcf_Minus(expr1, expr2)))
 in (LrTable.NT 2,(result,expr1left,expr2right),rest671) end
| (29,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.bop((
pcf_Times(expr1, expr2)))
 in (LrTable.NT 2,(result,expr1left,expr2right),rest671) end
| (30,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.bop((
pcf_Div(expr1, expr2)))
 in (LrTable.NT 2,(result,expr1left,expr2right),rest671) end
| (31,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.bop((
pcf_Equal(expr1, expr2)))
 in (LrTable.NT 2,(result,expr1left,expr2right),rest671) end
| (32,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.bop((
pcf_Less(expr1, expr2)))
 in (LrTable.NT 2,(result,expr1left,expr2right),rest671) end
| (33,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.bop((
pcf_Grtr(expr1, expr2)))
 in (LrTable.NT 2,(result,expr1left,expr2right),rest671) end
| (34,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.bop((
pcf_Leq(expr1, expr2)))
 in (LrTable.NT 2,(result,expr1left,expr2right),rest671) end
| (35,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.bop((
pcf_Geq(expr1, expr2)))
 in (LrTable.NT 2,(result,expr1left,expr2right),rest671) end
| (36,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.bop((
pcf_And(expr1, expr2)))
 in (LrTable.NT 2,(result,expr1left,expr2right),rest671) end
| (37,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.bop((
pcf_Or(expr1, expr2)))
 in (LrTable.NT 2,(result,expr1left,expr2right),rest671) end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.program x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a 
end
end
structure Tokens : PCF_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun LET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID,p1,p2))
fun LETREC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.VOID,p1,p2))
fun IN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.VOID,p1,p2))
fun VAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.VOID,p1,p2))
fun EQ (p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.VOID,p1,p2))
fun END (p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.VOID,p1,p2))
fun INTEGER (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.INTEGER i,p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.VOID,p1,p2))
fun OR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.VOID,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.VOID,p1,p2))
fun ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.ID i,p1,p2))
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID,p1,p2))
fun SEMI (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID,p1,p2))
fun LA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun RA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun LB (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.VOID,p1,p2))
fun RB (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID,p1,p2))
fun LEQ (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID,p1,p2))
fun GEQ (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID,p1,p2))
fun LOAD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun PRINT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun PLUS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun SUB (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun MULT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun DIV (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun MINUS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun FILE (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.FILE i,p1,p2))
fun FN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun MAPSTO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun IF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun THEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID,p1,p2))
fun ELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID,p1,p2))
fun FST (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.VOID,p1,p2))
fun SND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID,p1,p2))
fun TRUE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.VOID,p1,p2))
fun FALSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID,p1,p2))
fun QUIT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.VOID,p1,p2))
fun CONS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.VOID,p1,p2))
fun HD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.VOID,p1,p2))
fun TL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID,p1,p2))
fun NIL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.VOID,p1,p2))
fun NULL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(
ParserData.MlyValue.VOID,p1,p2))
end
end
