(* parser.sml
   Wrapper around all the Yacc-produced parsers *)


(* What's visible of the parsers to the outside world. *)
signature PARSER_INTERFACE =
    sig
    val kbd : unit -> CDSBasic.ParseTree
    val cell_kbd : unit -> CDSBasic.cellParse
    val pcf_kbd : unit -> PCFBasic.PCF_ParseTree
    val load : string * (CDSBasic.ParseTree -> unit) -> unit
    val pcf_load : string * (PCFBasic.PCF_ParseTree -> unit) -> unit
    val loadecho : string * (CDSBasic.ParseTree -> unit) -> unit
    end    (* signature PARSER_INTERFACE *)
    

functor ParserFUN (structure Interface : INTERFACE
		   structure CDSLrVals : CDS_LRVALS
		   structure CDSParser : PARSER
		      sharing type CDSParser.arg = Interface.arg
		      sharing type CDSParser.pos = Interface.pos
		      sharing type CDSParser.result = CDSBasic.ParseTree
		   structure CDSTokens : CDS_TOKENS
		      sharing type CDSTokens.token = CDSParser.Token.token =
			  CDSLrVals.Tokens.token
		      sharing type CDSTokens.svalue = CDSParser.svalue = 
			  CDSLrVals.Tokens.svalue
		   structure CellLrVals : Cell_LRVALS
		   structure CellParser : PARSER
		      sharing type CellParser.arg = Interface.arg
		      sharing type CellParser.pos = Interface.pos
		      sharing type CellParser.result = CDSBasic.cellParse
		   structure CellTokens : Cell_TOKENS
		      sharing type CellTokens.token = CellParser.Token.token =
			  CellLrVals.Tokens.token
		      sharing type CellTokens.svalue = CellParser.svalue = 
			  CellLrVals.Tokens.svalue
		   structure PCFLrVals : PCF_LRVALS
		   structure PCFParser : PARSER
		      sharing type PCFParser.arg = Interface.arg
		      sharing type PCFParser.pos = Interface.pos
		      sharing type PCFParser.result = PCFBasic.PCF_ParseTree
		   structure PCFTokens : PCF_TOKENS
		      sharing type PCFTokens.token = PCFParser.Token.token =
			  PCFLrVals.Tokens.token
		      sharing type PCFTokens.svalue = PCFParser.svalue = 
			  PCFLrVals.Tokens.svalue
		  ) : PARSER_INTERFACE =
    struct

    fun kbd () =
	let val dev = std_in
	    val stream = CDSParser.makeLexer (fn i => input_line dev)
	    val _ = Interface.init_line()
	    val (result, lexer) = 
		CDSParser.parse(0,stream,Interface.error,Interface.nothing)
	in result
	end

    fun cell_kbd () =
	let val dev = std_in
	    val stream = CellParser.makeLexer (fn i => input_line dev)
	    val _ = Interface.init_line()
	    val (result, lexer) = 
		CellParser.parse(0,stream,Interface.error,Interface.nothing)
	in result
	end

    fun pcf_kbd () =
	let val dev = std_in
	    val stream = PCFParser.makeLexer (fn i => input_line dev)
	    val _ = Interface.init_line()
	    val (result, lexer) = 
		PCFParser.parse(0,stream,Interface.error,Interface.nothing)
	in result
	end

    fun load (s, ProcessInput) =
	let val dev = open_in s
	    val stream = CDSParser.makeLexer(fn i => input(dev,i))
	    val _ = Interface.init_line()
	    val dummyEOF = 
		CDSLrVals.Tokens.EOF(Interface.dummy,Interface.dummy)
	    fun loop stream = 
		let val (result, stream) = 
		  CDSParser.parse(15,stream,Interface.error,Interface.nothing)
		    val (nextToken, stream) = CDSParser.Stream.get stream
		    val _ = ProcessInput result
		in if CDSParser.sameToken(nextToken,dummyEOF) 
		       then (close_in dev)
		   else loop stream
		end
	in loop stream
	end

    fun pcf_load (s, ProcessInput) =
	let val dev = open_in s
	    val stream = PCFParser.makeLexer(fn i => input(dev,i))
	    val _ = Interface.init_line()
	    val dummyEOF = 
		PCFLrVals.Tokens.EOF(Interface.dummy,Interface.dummy)
	    fun loop stream = 
		let val (result, stream) = 
		  PCFParser.parse(15,stream,Interface.error,Interface.nothing)
		    val (nextToken, stream) = PCFParser.Stream.get stream
		    val _ = ProcessInput result
		in if PCFParser.sameToken(nextToken,dummyEOF) 
		       then (close_in dev)
		   else loop stream
		end
	in loop stream
	end

    fun echo (dev, i) = let val s = input(dev, i)
			in (output(std_out, s);
			    s)
			end

    fun loadecho (s, ProcessInput) =
	let val dev = open_in s
	    val stream = CDSParser.makeLexer(fn i => echo(dev,i))
	    val _ = Interface.init_line()
	    val dummyEOF = 
		CDSLrVals.Tokens.EOF(Interface.dummy,Interface.dummy)
	    fun loop stream = 
		let val (result, stream) = 
		  CDSParser.parse(15,stream,Interface.error,Interface.nothing)
		    val (nextToken, stream) = CDSParser.Stream.get stream
		    val _ = ProcessInput result
		in if CDSParser.sameToken(nextToken,dummyEOF) 
		       then (close_in dev)
		   else loop stream
		end
	in loop stream
	end

    end    (* functor ParserFUN *)
