(* join.sml
   This is where the functor magic happens.
   Code to actually create all the structures. *)

  (* Parsing-related structures *)
structure CDSLrVals : CDS_LRVALS = 
    CDSLrValsFun(structure Token = LrParser.Token);

structure CellLrVals : Cell_LRVALS = 
    CellLrValsFun(structure Token = LrParser.Token);

structure PCFLrVals : PCF_LRVALS = 
    PCFLrValsFun(structure Token = LrParser.Token);

structure Interface : INTERFACE = InterfaceFUN();

structure CDSLex : LEXER = 
    CDSLexFun(structure Tokens = CDSLrVals.Tokens
	      structure Interface = Interface);

structure CellLex : LEXER = 
    CellLexFun(structure Tokens = CellLrVals.Tokens
	       structure Interface = Interface);

structure PCFLex : LEXER = 
    PCFLexFun(structure Tokens = PCFLrVals.Tokens
	      structure Interface = Interface);

structure CDSParser : PARSER = 
    Join(structure Lex = CDSLex
	 structure LrParser = LrParser
	 structure ParserData = CDSLrVals.ParserData);

structure CellParser : PARSER = 
    Join(structure Lex = CellLex
	 structure LrParser = LrParser
	 structure ParserData = CellLrVals.ParserData);

structure PCFParser : PARSER = 
    Join(structure Lex = PCFLex
	 structure LrParser = LrParser
	 structure ParserData = PCFLrVals.ParserData);


  (* CDS0 and PCF structures *)
structure Printer : PRINTER = PrinterFUN();

structure Parser : PARSER_INTERFACE = 
    ParserFUN(structure Interface = Interface
	      structure CDSLrVals = CDSLrVals
	      structure CDSParser = CDSParser
	      structure CDSTokens = CDSLrVals.Tokens
	      structure CellLrVals = CellLrVals
	      structure CellParser = CellParser
	      structure CellTokens = CellLrVals.Tokens
	      structure PCFLrVals = PCFLrVals
	      structure PCFParser = PCFParser
	      structure PCFTokens = PCFLrVals.Tokens);

structure Internal : INTERNAL = 
    InternalTranslatorFUN(structure Printer = Printer);

structure Match : MATCH = MatchFUN();

structure Eval : EVALUATOR = 
    EvaluatorFUN(structure Internal = Internal
		 structure Printer = Printer
		 structure Match = Match);

structure Type : TYPE = 
    TypeFUN(structure Internal = Internal
	    structure Printer = Printer);

structure Subtype : SUBTYPE = 
    SubtypeFUN(structure Internal = Internal
	       structure Type = Type
	       structure Printer = Printer);

structure TypeChecker : TYPE_CHECKER = 
    TypeCheckerFUN(structure Internal = Internal
		   structure Type = Type
		   structure Subtype = Subtype
		   structure Printer = Printer);

structure QandA : QANDA = 
    QandAFUN (structure Internal = Internal
	      structure Printer = Printer
	      structure Match = Match
	      structure Eval = Eval
	      structure Type = Type);

structure Refine : REFINE =
    RefineFUN(structure Printer = Printer
	      structure Internal = Internal
	      structure Type = Type
	      structure Subtype = Subtype
	      structure TypeChecker = TypeChecker
	      structure QandA = QandA);

structure PcfCode : PCF_CODE = 
    PcfCodeFUN(structure PCFParser = PCFParser
	       structure PCFLex = PCFLex
	       structure Interface = Interface
	       structure Parser = Parser
	       structure Printer = Printer);

structure Toplevel : TOPLEVEL =
    ToplevelFUN(structure CDSParser = CDSParser
		structure CellParser = CellParser
		structure CDSLex = CDSLex
		structure Interface = Interface
		structure Parser = Parser
		structure Internal = Internal
		structure Eval = Eval
		structure Printer = Printer
		structure Match = Match
		structure Type = Type
		structure TypeChecker = TypeChecker
		structure QandA = QandA
		structure Refine = Refine
		structure PcfCode = PcfCode);

open Toplevel;
