(* interface.sml
   Interface for the CDS lexer and Yacc-produced parser *)

(* Defines the abstract type of line numbers and operations on it.   *)
(* To be used for turning the lexer and parser into closed functors. *)
signature INTERFACE =
    sig
    type pos
    val dummy : pos
    val line : pos ref
    val init_line : unit -> unit
    val next_line : unit -> unit
    val error : string * pos * pos -> unit
    type arg
    val nothing : arg
    exception CommentError of string
    end    (* signature INTERFACE *)


functor InterfaceFUN () : INTERFACE =
    struct
    type pos = int
    val dummy = 0
    val line = ref 0
    fun init_line () = (line := 1)
    fun next_line () = (line := !line + 1)
    fun error (errmsg,line:pos,_) =
	output(std_out,"Line " ^ (makestring line) ^ ": " ^ errmsg ^ "\n")
    type arg = unit
    val nothing = ()
    exception CommentError of string
    end    (* functor InterfaceFUN *)
