functor CellLrValsFun (structure Token : TOKEN) : Cell_LRVALS = 
struct
structure ParserData=
struct
structure Header = 
struct
(* Cell name parser.  This is used to parse user's entries when
   in the request loop.  It is identical to the definitions in
   the main parser, but made into a separate parser in order to
   avoid having to type a special character before a cell name
   when in the request loop. *)

open CDSBasic


end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\003\000\015\000\000\000\
\\001\000\003\000\076\000\008\000\061\000\031\000\075\000\000\000\
\\001\000\003\000\076\000\031\000\075\000\000\000\
\\001\000\003\000\087\000\007\000\025\000\013\000\023\000\022\000\022\000\
\\026\000\020\000\000\000\
\\001\000\003\000\089\000\007\000\025\000\013\000\023\000\022\000\022\000\
\\026\000\020\000\000\000\
\\001\000\003\000\090\000\000\000\
\\001\000\006\000\000\000\014\000\000\000\000\000\
\\001\000\007\000\025\000\008\000\046\000\026\000\045\000\000\000\
\\001\000\007\000\025\000\012\000\024\000\013\000\023\000\022\000\022\000\
\\024\000\021\000\026\000\020\000\000\000\
\\001\000\007\000\025\000\012\000\035\000\013\000\034\000\017\000\033\000\
\\018\000\032\000\022\000\031\000\024\000\021\000\026\000\020\000\000\000\
\\001\000\007\000\025\000\012\000\035\000\013\000\034\000\017\000\033\000\
\\018\000\032\000\022\000\065\000\024\000\021\000\026\000\020\000\000\000\
\\001\000\007\000\025\000\013\000\023\000\022\000\022\000\026\000\020\000\000\000\
\\001\000\007\000\025\000\025\000\069\000\026\000\045\000\000\000\
\\001\000\007\000\025\000\025\000\081\000\026\000\045\000\000\000\
\\001\000\007\000\043\000\000\000\
\\001\000\007\000\043\000\013\000\042\000\022\000\041\000\000\000\
\\001\000\008\000\012\000\000\000\
\\001\000\008\000\058\000\000\000\
\\001\000\008\000\059\000\000\000\
\\001\000\008\000\061\000\000\000\
\\001\000\008\000\067\000\000\000\
\\001\000\010\000\072\000\011\000\071\000\023\000\092\000\000\000\
\\001\000\012\000\007\000\013\000\006\000\015\000\005\000\022\000\004\000\000\000\
\\001\000\016\000\013\000\000\000\
\\001\000\023\000\036\000\000\000\
\\001\000\023\000\060\000\027\000\040\000\028\000\039\000\029\000\038\000\
\\030\000\037\000\000\000\
\\001\000\023\000\066\000\027\000\040\000\028\000\039\000\029\000\038\000\
\\030\000\037\000\000\000\
\\001\000\023\000\083\000\000\000\
\\001\000\025\000\082\000\000\000\
\\001\000\025\000\093\000\000\000\
\\098\000\012\000\007\000\013\000\006\000\015\000\005\000\022\000\004\000\000\000\
\\099\000\000\000\
\\100\000\000\000\
\\101\000\000\000\
\\102\000\000\000\
\\103\000\000\000\
\\104\000\000\000\
\\105\000\027\000\040\000\028\000\039\000\029\000\038\000\030\000\037\000\000\000\
\\106\000\000\000\
\\107\000\000\000\
\\108\000\000\000\
\\109\000\000\000\
\\110\000\020\000\074\000\021\000\073\000\023\000\060\000\027\000\040\000\
\\028\000\039\000\029\000\038\000\030\000\037\000\000\000\
\\110\000\020\000\074\000\021\000\073\000\027\000\040\000\028\000\039\000\
\\029\000\038\000\030\000\037\000\000\000\
\\110\000\023\000\060\000\027\000\040\000\028\000\039\000\029\000\038\000\
\\030\000\037\000\000\000\
\\110\000\027\000\040\000\028\000\039\000\029\000\038\000\030\000\037\000\000\000\
\\111\000\000\000\
\\112\000\010\000\072\000\011\000\071\000\000\000\
\\113\000\000\000\
\\114\000\000\000\
\\115\000\000\000\
\\116\000\000\000\
\\117\000\000\000\
\\118\000\000\000\
\\119\000\000\000\
\\120\000\012\000\007\000\013\000\006\000\015\000\005\000\022\000\004\000\000\000\
\\121\000\009\000\014\000\000\000\
\\122\000\000\000\
\\123\000\000\000\
\\124\000\000\000\
\\125\000\000\000\
\\125\000\019\000\052\000\000\000\
\\126\000\000\000\
\\127\000\000\000\
\\128\000\029\000\038\000\030\000\037\000\000\000\
\\129\000\029\000\038\000\030\000\037\000\000\000\
\\130\000\000\000\
\\131\000\000\000\
\\132\000\000\000\
\\133\000\027\000\040\000\028\000\039\000\029\000\038\000\030\000\037\000\000\000\
\\134\000\027\000\040\000\028\000\039\000\029\000\038\000\030\000\037\000\000\000\
\\135\000\027\000\040\000\028\000\039\000\029\000\038\000\030\000\037\000\000\000\
\\136\000\027\000\040\000\028\000\039\000\029\000\038\000\030\000\037\000\000\000\
\\137\000\000\000\
\\138\000\000\000\
\\139\000\000\000\
\\140\000\000\000\
\\141\000\000\000\
\"
val actionRowNumbers =
"\030\000\031\000\022\000\055\000\
\\033\000\032\000\016\000\023\000\
\\056\000\000\000\008\000\022\000\
\\055\000\009\000\059\000\024\000\
\\037\000\038\000\015\000\007\000\
\\011\000\060\000\036\000\053\000\
\\034\000\057\000\045\000\048\000\
\\058\000\009\000\009\000\022\000\
\\061\000\039\000\035\000\011\000\
\\011\000\011\000\011\000\011\000\
\\062\000\054\000\017\000\014\000\
\\018\000\025\000\044\000\019\000\
\\041\000\040\000\010\000\067\000\
\\066\000\065\000\064\000\026\000\
\\020\000\012\000\068\000\009\000\
\\047\000\043\000\002\000\010\000\
\\063\000\013\000\028\000\049\000\
\\027\000\010\000\010\000\003\000\
\\004\000\005\000\009\000\021\000\
\\042\000\001\000\029\000\050\000\
\\051\000\046\000\076\000\075\000\
\\069\000\011\000\071\000\011\000\
\\009\000\073\000\077\000\052\000\
\\070\000\072\000\074\000\006\000"
val gotoT =
"\
\\001\000\095\000\002\000\001\000\000\000\
\\000\000\
\\002\000\006\000\000\000\
\\002\000\009\000\006\000\008\000\009\000\007\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\008\000\017\000\010\000\016\000\012\000\015\000\013\000\014\000\000\000\
\\002\000\024\000\000\000\
\\002\000\009\000\006\000\008\000\009\000\025\000\000\000\
\\007\000\028\000\008\000\027\000\010\000\026\000\013\000\014\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\013\000\042\000\000\000\
\\010\000\045\000\013\000\014\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\047\000\008\000\027\000\010\000\046\000\013\000\014\000\000\000\
\\007\000\048\000\008\000\027\000\010\000\026\000\013\000\014\000\000\000\
\\002\000\049\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\010\000\051\000\013\000\014\000\000\000\
\\010\000\052\000\013\000\014\000\000\000\
\\010\000\053\000\013\000\014\000\000\000\
\\010\000\054\000\013\000\014\000\000\000\
\\010\000\055\000\013\000\014\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\062\000\008\000\027\000\010\000\061\000\011\000\060\000\
\\013\000\014\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\013\000\066\000\000\000\
\\000\000\
\\007\000\068\000\008\000\027\000\010\000\026\000\013\000\014\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\077\000\008\000\027\000\010\000\076\000\011\000\075\000\
\\013\000\014\000\000\000\
\\000\000\
\\013\000\078\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\062\000\008\000\027\000\010\000\061\000\011\000\082\000\
\\013\000\014\000\000\000\
\\007\000\062\000\008\000\027\000\010\000\061\000\011\000\083\000\
\\013\000\014\000\000\000\
\\010\000\084\000\013\000\014\000\000\000\
\\010\000\086\000\013\000\014\000\000\000\
\\000\000\
\\007\000\089\000\008\000\027\000\010\000\026\000\013\000\014\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\010\000\092\000\013\000\014\000\000\000\
\\000\000\
\\010\000\093\000\013\000\014\000\000\000\
\\007\000\094\000\008\000\027\000\010\000\026\000\013\000\014\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 96
val numrules = 44
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; ordof(!s,i) + ordof(!s,i+1) * 256
end
val string_to_list = fn s' =>
    let val len = String.length s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.length s'
 	 fun f ()=
	    if !index < len then convert_row() :: f()
	    else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
	fun f i =
	     if i=numstates then g i
	     else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
	   in f 0 handle Subscript => ()
	   end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.arrayoflist(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.arrayoflist(actionRows) in fn i=>Array.sub(a,i) end
in Array.arrayoflist(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = int
type arg = unit
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit | VAR of  (string)
 | ID of  (string) | INTEGER of  (int) | int of  (int) | tag of  (tag)
 | boolexp of  (boolexp) | arexpr of  (arexpr)
 | event_list of  (state) | interval of  (value) | value of  (value)
 | event of  (event) | enabling of  (access list)
 | access_list of  (access list) | value_list of  (value list)
 | cell_name of  (cell) | cell_name_parse of  (cellParse)
end
type svalue = MlyValue.svalue
type result = cellParse
end
structure EC=
struct
open LrTable
val is_keyword =
fn (T 17) => true | (T 16) => true | (T 9) => true | (T 10) => true | _ => false
val preferred_insert =
fn _ => false
val preferred_subst =
fn  _ => nil
val noShift = 
fn (T 13) => true | _ => false
val showTerminal =
fn (T 0) => "LET"
  | (T 1) => "LETREC"
  | (T 2) => "EQ"
  | (T 3) => "DCDS"
  | (T 4) => "END"
  | (T 5) => "SEMI"
  | (T 6) => "INTEGER"
  | (T 7) => "APPLY"
  | (T 8) => "COMMA"
  | (T 9) => "OR"
  | (T 10) => "AND"
  | (T 11) => "ID"
  | (T 12) => "VAR"
  | (T 13) => "EOF"
  | (T 14) => "LC"
  | (T 15) => "RC"
  | (T 16) => "VALOF"
  | (T 17) => "OUTPUT"
  | (T 18) => "WITH"
  | (T 19) => "LA"
  | (T 20) => "RA"
  | (T 21) => "LB"
  | (T 22) => "RB"
  | (T 23) => "LS"
  | (T 24) => "RS"
  | (T 25) => "MINUS"
  | (T 26) => "PLUS"
  | (T 27) => "SUB"
  | (T 28) => "MULT"
  | (T 29) => "DIV"
  | (T 30) => "BANG"
  | _ => "bogus-term"
val errtermvalue=
let open Header in
fn _ => MlyValue.VOID
end
val terms = (T 0) :: (T 1) :: (T 2) :: (T 3) :: (T 4) :: (T 5) :: (T 7
) :: (T 8) :: (T 9) :: (T 10) :: (T 13) :: (T 14) :: (T 15) :: (T 16)
 :: (T 17) :: (T 18) :: (T 19) :: (T 20) :: (T 21) :: (T 22) :: (T 23)
 :: (T 24) :: (T 25) :: (T 26) :: (T 27) :: (T 28) :: (T 29) :: (T 30)
 :: nil
end
structure Actions =
struct 
exception mlyAction of int
val actions = 
let open Header
in
fn (i392,defaultPos,stack,
    (()):arg) =>
case (i392,stack)
of (0,rest671) => let val result=MlyValue.cell_name_parse((Empty))
 in (LrTable.NT 0,(result,defaultPos,defaultPos),rest671) end
| (1,(_,(MlyValue.cell_name cell_name,cell_name1left,cell_name1right))
::rest671) => let val result=MlyValue.cell_name_parse((Name cell_name)
)
 in (LrTable.NT 0,(result,cell_name1left,cell_name1right),rest671) end
| (2,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val result
=MlyValue.cell_name((Cell_name ID))
 in (LrTable.NT 1,(result,ID1left,ID1right),rest671) end
| (3,(_,(MlyValue.VAR VAR,VAR1left,VAR1right))::rest671) => let val 
result=MlyValue.cell_name((Cell_var VAR))
 in (LrTable.NT 1,(result,VAR1left,VAR1right),rest671) end
| (4,(_,(MlyValue.cell_name cell_name,_,cell_name1right))::_::(_,(
MlyValue.event_list event_list,_,_))::(_,(_,LC1left,_))::rest671) => 
let val result=MlyValue.cell_name((
Cell_fun (Expr_state event_list, cell_name)))
 in (LrTable.NT 1,(result,LC1left,cell_name1right),rest671) end
| (5,(_,(_,_,RB1right))::(_,(MlyValue.tag tag,_,_))::_::(_,(
MlyValue.cell_name cell_name,_,_))::(_,(_,LB1left,_))::rest671) => 
let val result=MlyValue.cell_name((Cell_graft (cell_name, tag)))
 in (LrTable.NT 1,(result,LB1left,RB1right),rest671) end
| (6,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val result
=MlyValue.tag((Tag_str ID))
 in (LrTable.NT 11,(result,ID1left,ID1right),rest671) end
| (7,(_,(MlyValue.arexpr arexpr,arexpr1left,arexpr1right))::rest671)
 => let val result=MlyValue.tag((Tag_arexpr arexpr))
 in (LrTable.NT 11,(result,arexpr1left,arexpr1right),rest671) end
| (8,(_,(MlyValue.interval interval,interval1left,interval1right))::
rest671) => let val result=MlyValue.tag((Tag_interval interval))
 in (LrTable.NT 11,(result,interval1left,interval1right),rest671) end
| (9,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val result
=MlyValue.value((Val_string ID))
 in (LrTable.NT 6,(result,ID1left,ID1right),rest671) end
| (10,(_,(MlyValue.cell_name cell_name,_,cell_name1right))::(_,(_,
VALOF1left,_))::rest671) => let val result=MlyValue.value((
Val_valof cell_name))
 in (LrTable.NT 6,(result,VALOF1left,cell_name1right),rest671) end
| (11,(_,(MlyValue.value value,_,value1right))::(_,(_,OUTPUT1left,_))
::rest671) => let val result=MlyValue.value((Val_output value))
 in (LrTable.NT 6,(result,OUTPUT1left,value1right),rest671) end
| (12,(_,(MlyValue.arexpr arexpr,arexpr1left,arexpr1right))::rest671)
 => let val result=MlyValue.value((Val_arexpr arexpr))
 in (LrTable.NT 6,(result,arexpr1left,arexpr1right),rest671) end
| (13,(_,(_,_,RB1right))::(_,(MlyValue.value value2,_,_))::_::(_,(
MlyValue.value value1,_,_))::(_,(_,LB1left,_))::rest671) => let val 
result=MlyValue.value((Val_pair (value1, value2)))
 in (LrTable.NT 6,(result,LB1left,RB1right),rest671) end
| (14,(_,(MlyValue.boolexp boolexp,_,boolexp1right))::_::(_,(
MlyValue.VAR VAR,VAR1left,_))::rest671) => let val result=
MlyValue.value((Val_with (VAR, boolexp)))
 in (LrTable.NT 6,(result,VAR1left,boolexp1right),rest671) end
| (15,(_,(MlyValue.interval interval,interval1left,interval1right))::
rest671) => let val result=MlyValue.value((interval))
 in (LrTable.NT 6,(result,interval1left,interval1right),rest671) end
| (16,(_,(_,_,RS1right))::_::_::(_,(_,LS1left,_))::rest671) => let 
val result=MlyValue.interval((Val_interval_inf))
 in (LrTable.NT 7,(result,LS1left,RS1right),rest671) end
| (17,(_,(_,_,RS1right))::_::_::(_,(MlyValue.int int,_,_))::(_,(_,
LS1left,_))::rest671) => let val result=MlyValue.interval((
Val_interval_from int))
 in (LrTable.NT 7,(result,LS1left,RS1right),rest671) end
| (18,(_,(_,_,RS1right))::(_,(MlyValue.int int,_,_))::_::_::(_,(_,
LS1left,_))::rest671) => let val result=MlyValue.interval((
Val_interval_to int))
 in (LrTable.NT 7,(result,LS1left,RS1right),rest671) end
| (19,(_,(_,_,RS1right))::(_,(MlyValue.int int2,_,_))::_::_::(_,(
MlyValue.int int1,_,_))::(_,(_,LS1left,_))::rest671) => let val result
=MlyValue.interval((Val_interval_fromto(int1,int2)))
 in (LrTable.NT 7,(result,LS1left,RS1right),rest671) end
| (20,(_,(MlyValue.INTEGER INTEGER,INTEGER1left,INTEGER1right))::
rest671) => let val result=MlyValue.int((INTEGER))
 in (LrTable.NT 12,(result,INTEGER1left,INTEGER1right),rest671) end
| (21,(_,(MlyValue.INTEGER INTEGER,_,INTEGER1right))::(_,(_,MINUS1left
,_))::rest671) => let val result=MlyValue.int((~INTEGER))
 in (LrTable.NT 12,(result,MINUS1left,INTEGER1right),rest671) end
| (22,rest671) => let val result=MlyValue.event_list(([]))
 in (LrTable.NT 8,(result,defaultPos,defaultPos),rest671) end
| (23,(_,(MlyValue.event event,event1left,event1right))::rest671) => 
let val result=MlyValue.event_list(([event]))
 in (LrTable.NT 8,(result,event1left,event1right),rest671) end
| (24,(_,(MlyValue.event_list event_list,_,event_list1right))::_::(_,(
MlyValue.event event,event1left,_))::rest671) => let val result=
MlyValue.event_list((event :: event_list))
 in (LrTable.NT 8,(result,event1left,event_list1right),rest671) end
| (25,(_,(MlyValue.value value,_,value1right))::_::(_,(
MlyValue.cell_name cell_name,cell_name1left,_))::rest671) => let val 
result=MlyValue.event(((cell_name, value)))
 in (LrTable.NT 5,(result,cell_name1left,value1right),rest671) end
| (26,(_,(MlyValue.int int,int1left,int1right))::rest671) => let val 
result=MlyValue.arexpr((Arexpr_int int))
 in (LrTable.NT 9,(result,int1left,int1right),rest671) end
| (27,(_,(MlyValue.VAR VAR,VAR1left,VAR1right))::rest671) => let val 
result=MlyValue.arexpr((Arexpr_var VAR))
 in (LrTable.NT 9,(result,VAR1left,VAR1right),rest671) end
| (28,(_,(MlyValue.VAR VAR,_,VAR1right))::(_,(_,MINUS1left,_))::
rest671) => let val result=MlyValue.arexpr((
Arexpr_minus (Arexpr_var VAR)))
 in (LrTable.NT 9,(result,MINUS1left,VAR1right),rest671) end
| (29,(_,(_,_,RB1right))::(_,(MlyValue.arexpr arexpr,_,_))::_::(_,(_,
MINUS1left,_))::rest671) => let val result=MlyValue.arexpr((
Arexpr_minus arexpr))
 in (LrTable.NT 9,(result,MINUS1left,RB1right),rest671) end
| (30,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.arexpr((Arexpr_plus (arexpr1, arexpr2)))
 in (LrTable.NT 9,(result,arexpr1left,arexpr2right),rest671) end
| (31,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.arexpr((Arexpr_sub (arexpr1, arexpr2)))
 in (LrTable.NT 9,(result,arexpr1left,arexpr2right),rest671) end
| (32,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.arexpr((Arexpr_mult (arexpr1, arexpr2)))
 in (LrTable.NT 9,(result,arexpr1left,arexpr2right),rest671) end
| (33,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.arexpr((Arexpr_div (arexpr1, arexpr2)))
 in (LrTable.NT 9,(result,arexpr1left,arexpr2right),rest671) end
| (34,(_,(_,_,RB1right))::(_,(MlyValue.arexpr arexpr,_,_))::(_,(_,
LB1left,_))::rest671) => let val result=MlyValue.arexpr((arexpr))
 in (LrTable.NT 9,(result,LB1left,RB1right),rest671) end
| (35,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.boolexp((Boolexp_gt (arexpr1, arexpr2)))
 in (LrTable.NT 10,(result,arexpr1left,arexpr2right),rest671) end
| (36,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.boolexp((Boolexp_gteq (arexpr1, arexpr2)))
 in (LrTable.NT 10,(result,arexpr1left,arexpr2right),rest671) end
| (37,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.boolexp((Boolexp_lt (arexpr1, arexpr2)))
 in (LrTable.NT 10,(result,arexpr1left,arexpr2right),rest671) end
| (38,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.boolexp((Boolexp_lteq (arexpr1, arexpr2)))
 in (LrTable.NT 10,(result,arexpr1left,arexpr2right),rest671) end
| (39,(_,(MlyValue.value value2,_,value2right))::_::(_,(MlyValue.value
 value1,value1left,_))::rest671) => let val result=MlyValue.boolexp((
Boolexp_eq (value1, value2)))
 in (LrTable.NT 10,(result,value1left,value2right),rest671) end
| (40,(_,(MlyValue.value value2,_,value2right))::_::_::(_,(
MlyValue.value value1,value1left,_))::rest671) => let val result=
MlyValue.boolexp((Boolexp_noteq (value1, value2)))
 in (LrTable.NT 10,(result,value1left,value2right),rest671) end
| (41,(_,(MlyValue.boolexp boolexp2,_,boolexp2right))::_::(_,(
MlyValue.boolexp boolexp1,boolexp1left,_))::rest671) => let val result
=MlyValue.boolexp((Boolexp_or (boolexp1, boolexp2)))
 in (LrTable.NT 10,(result,boolexp1left,boolexp2right),rest671) end
| (42,(_,(MlyValue.boolexp boolexp2,_,boolexp2right))::_::(_,(
MlyValue.boolexp boolexp1,boolexp1left,_))::rest671) => let val result
=MlyValue.boolexp((Boolexp_and (boolexp1, boolexp2)))
 in (LrTable.NT 10,(result,boolexp1left,boolexp2right),rest671) end
| (43,(_,(_,_,RB1right))::(_,(MlyValue.boolexp boolexp,_,_))::(_,(_,
LB1left,_))::rest671) => let val result=MlyValue.boolexp((boolexp))
 in (LrTable.NT 10,(result,LB1left,RB1right),rest671) end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.cell_name_parse x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a 
end
end
structure Tokens : Cell_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun LET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID,p1,p2))
fun LETREC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.VOID,p1,p2))
fun EQ (p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.VOID,p1,p2))
fun DCDS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.VOID,p1,p2))
fun END (p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.VOID,p1,p2))
fun SEMI (p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.VOID,p1,p2))
fun INTEGER (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.INTEGER i,p1,p2))
fun APPLY (p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.VOID,p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.VOID,p1,p2))
fun OR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.VOID,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.VOID,p1,p2))
fun ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.ID i,p1,p2))
fun VAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VAR i,p1,p2))
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun LC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun RC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.VOID,p1,p2))
fun VALOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID,p1,p2))
fun OUTPUT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID,p1,p2))
fun WITH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID,p1,p2))
fun LA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun RA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun LB (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun RB (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun LS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun RS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun MINUS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun PLUS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID,p1,p2))
fun SUB (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun MULT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun DIV (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun BANG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID,p1,p2))
end
end
