functor CDSLrValsFun (structure Token : TOKEN) : CDS_LRVALS = 
struct
structure ParserData=
struct
structure Header = 
struct
(* CDS Parser Definition *)

open CDSBasic


end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\001\000\034\000\002\000\027\000\061\000\008\000\000\000\
\\001\000\003\000\078\000\000\000\
\\001\000\003\000\084\000\000\000\
\\001\000\003\000\085\000\000\000\
\\001\000\003\000\179\000\010\000\151\000\053\000\178\000\000\000\
\\001\000\003\000\179\000\053\000\178\000\000\000\
\\001\000\003\000\198\000\008\000\106\000\017\000\135\000\033\000\134\000\
\\037\000\099\000\000\000\
\\001\000\003\000\200\000\008\000\106\000\017\000\135\000\033\000\134\000\
\\037\000\099\000\000\000\
\\001\000\003\000\201\000\000\000\
\\001\000\004\000\111\000\000\000\
\\001\000\004\000\111\000\015\000\026\000\016\000\025\000\023\000\024\000\
\\031\000\023\000\033\000\022\000\042\000\019\000\043\000\018\000\
\\044\000\017\000\000\000\
\\001\000\005\000\083\000\020\000\082\000\000\000\
\\001\000\005\000\113\000\000\000\
\\001\000\005\000\166\000\000\000\
\\001\000\005\000\184\000\000\000\
\\001\000\005\000\222\000\008\000\106\000\016\000\105\000\017\000\104\000\
\\025\000\103\000\028\000\102\000\033\000\101\000\035\000\100\000\
\\037\000\099\000\000\000\
\\001\000\005\000\230\000\000\000\
\\001\000\006\000\000\000\018\000\000\000\000\000\
\\001\000\008\000\037\000\058\000\036\000\000\000\
\\001\000\008\000\068\000\000\000\
\\001\000\008\000\106\000\010\000\125\000\037\000\124\000\000\000\
\\001\000\008\000\106\000\016\000\105\000\017\000\104\000\025\000\103\000\
\\028\000\102\000\033\000\101\000\035\000\100\000\037\000\099\000\000\000\
\\001\000\008\000\106\000\016\000\105\000\017\000\104\000\025\000\103\000\
\\028\000\102\000\033\000\155\000\035\000\100\000\037\000\099\000\000\000\
\\001\000\008\000\106\000\016\000\136\000\017\000\135\000\033\000\134\000\
\\035\000\100\000\037\000\099\000\000\000\
\\001\000\008\000\106\000\017\000\135\000\033\000\134\000\037\000\099\000\000\000\
\\001\000\008\000\106\000\036\000\172\000\037\000\124\000\000\000\
\\001\000\008\000\106\000\036\000\192\000\037\000\124\000\000\000\
\\001\000\008\000\122\000\000\000\
\\001\000\008\000\122\000\017\000\121\000\033\000\120\000\000\000\
\\001\000\010\000\030\000\011\000\074\000\030\000\029\000\034\000\073\000\000\000\
\\001\000\010\000\030\000\011\000\075\000\030\000\029\000\000\000\
\\001\000\010\000\030\000\030\000\029\000\032\000\115\000\000\000\
\\001\000\010\000\030\000\030\000\029\000\034\000\089\000\000\000\
\\001\000\010\000\030\000\030\000\029\000\034\000\090\000\000\000\
\\001\000\010\000\030\000\030\000\029\000\034\000\091\000\000\000\
\\001\000\010\000\030\000\030\000\029\000\034\000\114\000\000\000\
\\001\000\010\000\107\000\000\000\
\\001\000\010\000\148\000\000\000\
\\001\000\010\000\149\000\000\000\
\\001\000\010\000\151\000\000\000\
\\001\000\010\000\170\000\000\000\
\\001\000\013\000\175\000\014\000\174\000\034\000\203\000\000\000\
\\001\000\015\000\026\000\016\000\025\000\023\000\024\000\031\000\023\000\
\\033\000\022\000\042\000\019\000\043\000\018\000\044\000\017\000\000\000\
\\001\000\016\000\032\000\000\000\
\\001\000\016\000\040\000\000\000\
\\001\000\016\000\058\000\017\000\057\000\023\000\056\000\033\000\055\000\000\000\
\\001\000\016\000\061\000\000\000\
\\001\000\016\000\063\000\000\000\
\\001\000\016\000\069\000\000\000\
\\001\000\016\000\088\000\000\000\
\\001\000\019\000\190\000\000\000\
\\001\000\021\000\138\000\000\000\
\\001\000\021\000\223\000\000\000\
\\001\000\022\000\164\000\025\000\163\000\028\000\162\000\052\000\161\000\000\000\
\\001\000\023\000\187\000\000\000\
\\001\000\024\000\076\000\000\000\
\\001\000\024\000\108\000\000\000\
\\001\000\024\000\216\000\000\000\
\\001\000\026\000\204\000\000\000\
\\001\000\027\000\227\000\000\000\
\\001\000\033\000\043\000\000\000\
\\001\000\033\000\044\000\000\000\
\\001\000\033\000\045\000\000\000\
\\001\000\034\000\150\000\048\000\119\000\049\000\118\000\050\000\117\000\
\\051\000\116\000\000\000\
\\001\000\034\000\156\000\000\000\
\\001\000\034\000\169\000\048\000\119\000\049\000\118\000\050\000\117\000\
\\051\000\116\000\000\000\
\\001\000\034\000\194\000\000\000\
\\001\000\036\000\193\000\000\000\
\\001\000\036\000\211\000\000\000\
\\001\000\040\000\039\000\041\000\038\000\000\000\
\\001\000\040\000\047\000\041\000\046\000\000\000\
\\001\000\040\000\049\000\041\000\048\000\000\000\
\\001\000\054\000\035\000\000\000\
\\001\000\054\000\041\000\000\000\
\\001\000\054\000\042\000\000\000\
\\001\000\062\000\067\000\000\000\
\\232\000\001\000\028\000\002\000\027\000\015\000\026\000\016\000\025\000\
\\023\000\024\000\031\000\023\000\033\000\022\000\038\000\021\000\
\\039\000\020\000\042\000\019\000\043\000\018\000\044\000\017\000\
\\045\000\016\000\046\000\015\000\047\000\014\000\055\000\013\000\
\\056\000\012\000\057\000\011\000\059\000\010\000\060\000\009\000\
\\061\000\008\000\063\000\007\000\000\000\
\\233\000\010\000\030\000\030\000\029\000\000\000\
\\234\000\000\000\
\\235\000\000\000\
\\236\000\000\000\
\\237\000\000\000\
\\238\000\000\000\
\\239\000\000\000\
\\240\000\010\000\030\000\030\000\029\000\000\000\
\\241\000\010\000\030\000\030\000\029\000\000\000\
\\242\000\000\000\
\\243\000\000\000\
\\244\000\000\000\
\\245\000\000\000\
\\246\000\000\000\
\\247\000\010\000\030\000\030\000\029\000\000\000\
\\248\000\000\000\
\\249\000\000\000\
\\250\000\000\000\
\\251\000\000\000\
\\252\000\000\000\
\\253\000\000\000\
\\254\000\000\000\
\\255\000\000\000\
\\000\001\000\000\
\\001\001\000\000\
\\002\001\000\000\
\\003\001\000\000\
\\004\001\000\000\
\\005\001\000\000\
\\006\001\000\000\
\\007\001\011\000\066\000\000\000\
\\008\001\000\000\
\\009\001\000\000\
\\010\001\000\000\
\\011\001\000\000\
\\012\001\000\000\
\\013\001\007\000\142\000\009\000\141\000\000\000\
\\014\001\000\000\
\\015\001\000\000\
\\016\001\000\000\
\\017\001\000\000\
\\018\001\000\000\
\\019\001\000\000\
\\020\001\000\000\
\\021\001\048\000\119\000\049\000\118\000\050\000\117\000\051\000\116\000\000\000\
\\022\001\000\000\
\\023\001\000\000\
\\024\001\000\000\
\\025\001\000\000\
\\026\001\031\000\177\000\032\000\176\000\034\000\150\000\048\000\119\000\
\\049\000\118\000\050\000\117\000\051\000\116\000\000\000\
\\026\001\031\000\177\000\032\000\176\000\048\000\119\000\049\000\118\000\
\\050\000\117\000\051\000\116\000\000\000\
\\026\001\034\000\150\000\048\000\119\000\049\000\118\000\050\000\117\000\
\\051\000\116\000\000\000\
\\026\001\048\000\119\000\049\000\118\000\050\000\117\000\051\000\116\000\000\000\
\\027\001\000\000\
\\028\001\013\000\175\000\014\000\174\000\000\000\
\\029\001\000\000\
\\030\001\000\000\
\\031\001\000\000\
\\032\001\000\000\
\\033\001\000\000\
\\034\001\000\000\
\\035\001\000\000\
\\036\001\011\000\218\000\000\000\
\\037\001\000\000\
\\038\001\012\000\189\000\000\000\
\\039\001\000\000\
\\040\001\013\000\217\000\000\000\
\\041\001\000\000\
\\042\001\016\000\058\000\017\000\057\000\023\000\056\000\033\000\055\000\000\000\
\\043\001\011\000\077\000\000\000\
\\044\001\000\000\
\\045\001\000\000\
\\046\001\000\000\
\\047\001\000\000\
\\047\001\029\000\130\000\000\000\
\\048\001\000\000\
\\049\001\000\000\
\\050\001\050\000\117\000\051\000\116\000\000\000\
\\051\001\050\000\117\000\051\000\116\000\000\000\
\\052\001\000\000\
\\053\001\000\000\
\\054\001\000\000\
\\055\001\048\000\119\000\049\000\118\000\050\000\117\000\051\000\116\000\000\000\
\\056\001\048\000\119\000\049\000\118\000\050\000\117\000\051\000\116\000\000\000\
\\057\001\048\000\119\000\049\000\118\000\050\000\117\000\051\000\116\000\000\000\
\\058\001\048\000\119\000\049\000\118\000\050\000\117\000\051\000\116\000\000\000\
\\059\001\000\000\
\\060\001\000\000\
\\061\001\000\000\
\\062\001\000\000\
\\063\001\000\000\
\\064\001\000\000\
\\065\001\000\000\
\\066\001\000\000\
\\067\001\000\000\
\\068\001\029\000\139\000\000\000\
\\069\001\013\000\175\000\014\000\174\000\000\000\
\\070\001\000\000\
\\071\001\000\000\
\\072\001\022\000\164\000\000\000\
\\073\001\000\000\
\\074\001\000\000\
\\075\001\000\000\
\\076\001\000\000\
\\077\001\000\000\
\\078\001\000\000\
\\079\001\000\000\
\"
val actionRowNumbers =
"\076\000\081\000\079\000\078\000\
\\077\000\043\000\000\000\105\000\
\\072\000\018\000\069\000\104\000\
\\044\000\073\000\074\000\060\000\
\\061\000\062\000\070\000\071\000\
\\042\000\042\000\145\000\090\000\
\\169\000\046\000\047\000\042\000\
\\042\000\106\000\107\000\075\000\
\\046\000\103\000\019\000\048\000\
\\100\000\099\000\092\000\094\000\
\\093\000\042\000\042\000\042\000\
\\096\000\095\000\098\000\097\000\
\\029\000\030\000\055\000\146\000\
\\001\000\045\000\145\000\117\000\
\\116\000\011\000\109\000\002\000\
\\110\000\003\000\084\000\085\000\
\\043\000\000\000\049\000\101\000\
\\032\000\033\000\034\000\089\000\
\\042\000\042\000\080\000\145\000\
\\021\000\036\000\056\000\170\000\
\\045\000\168\000\009\000\010\000\
\\108\000\012\000\102\000\088\000\
\\083\000\082\000\035\000\031\000\
\\147\000\149\000\129\000\132\000\
\\148\000\028\000\020\000\021\000\
\\021\000\045\000\151\000\123\000\
\\137\000\023\000\045\000\051\000\
\\172\000\113\000\091\000\111\000\
\\087\000\086\000\024\000\024\000\
\\024\000\024\000\024\000\152\000\
\\138\000\037\000\027\000\038\000\
\\128\000\039\000\125\000\124\000\
\\022\000\064\000\121\000\122\000\
\\024\000\150\000\120\000\118\000\
\\053\000\022\000\013\000\045\000\
\\045\000\157\000\156\000\155\000\
\\154\000\065\000\040\000\025\000\
\\158\000\021\000\131\000\127\000\
\\005\000\022\000\119\000\063\000\
\\176\000\178\000\014\000\177\000\
\\021\000\045\000\054\000\173\000\
\\112\000\141\000\050\000\153\000\
\\026\000\067\000\133\000\066\000\
\\022\000\022\000\006\000\007\000\
\\008\000\021\000\041\000\126\000\
\\004\000\179\000\171\000\174\000\
\\058\000\145\000\113\000\145\000\
\\021\000\068\000\134\000\135\000\
\\130\000\166\000\165\000\159\000\
\\024\000\161\000\024\000\021\000\
\\163\000\167\000\182\000\057\000\
\\115\000\143\000\142\000\139\000\
\\141\000\136\000\160\000\162\000\
\\164\000\015\000\052\000\145\000\
\\021\000\113\000\183\000\059\000\
\\175\000\053\000\144\000\140\000\
\\114\000\053\000\016\000\181\000\
\\180\000\017\000"
val gotoT =
"\
\\001\000\229\000\002\000\004\000\003\000\003\000\005\000\002\000\
\\017\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\004\000\029\000\000\000\
\\005\000\031\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\048\000\017\000\001\000\000\000\
\\002\000\049\000\017\000\001\000\000\000\
\\008\000\052\000\013\000\051\000\016\000\050\000\000\000\
\\000\000\
\\019\000\057\000\000\000\
\\006\000\058\000\000\000\
\\006\000\060\000\000\000\
\\002\000\062\000\017\000\001\000\000\000\
\\002\000\063\000\017\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\006\000\060\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\068\000\017\000\001\000\000\000\
\\002\000\069\000\017\000\001\000\000\000\
\\002\000\070\000\017\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\008\000\077\000\000\000\
\\008\000\052\000\013\000\051\000\016\000\078\000\000\000\
\\000\000\
\\000\000\
\\018\000\079\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\004\000\084\000\000\000\
\\005\000\085\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\090\000\017\000\001\000\000\000\
\\002\000\091\000\017\000\001\000\000\000\
\\000\000\
\\008\000\052\000\013\000\051\000\016\000\092\000\000\000\
\\014\000\096\000\015\000\095\000\025\000\094\000\028\000\093\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\008\000\108\000\009\000\107\000\000\000\
\\000\000\
\\000\000\
\\002\000\110\000\017\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\028\000\121\000\000\000\
\\014\000\125\000\015\000\095\000\025\000\124\000\028\000\093\000\000\000\
\\014\000\126\000\015\000\095\000\025\000\094\000\028\000\093\000\000\000\
\\008\000\127\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\015\000\131\000\025\000\130\000\027\000\129\000\028\000\093\000\000\000\
\\008\000\135\000\000\000\
\\000\000\
\\000\000\
\\007\000\138\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\025\000\141\000\028\000\093\000\000\000\
\\025\000\142\000\028\000\093\000\000\000\
\\025\000\143\000\028\000\093\000\000\000\
\\025\000\144\000\028\000\093\000\000\000\
\\025\000\145\000\028\000\093\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\014\000\152\000\015\000\095\000\025\000\151\000\026\000\150\000\
\\028\000\093\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\025\000\155\000\028\000\093\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\020\000\158\000\021\000\157\000\022\000\156\000\000\000\
\\014\000\152\000\015\000\095\000\025\000\151\000\026\000\163\000\
\\028\000\093\000\000\000\
\\000\000\
\\008\000\165\000\000\000\
\\008\000\166\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\028\000\169\000\000\000\
\\000\000\
\\014\000\171\000\015\000\095\000\025\000\094\000\028\000\093\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\014\000\180\000\015\000\095\000\025\000\179\000\026\000\178\000\
\\028\000\093\000\000\000\
\\000\000\
\\000\000\
\\021\000\181\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\014\000\183\000\015\000\095\000\025\000\094\000\028\000\093\000\000\000\
\\008\000\184\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\011\000\186\000\000\000\
\\000\000\
\\000\000\
\\028\000\189\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\014\000\152\000\015\000\095\000\025\000\151\000\026\000\193\000\
\\028\000\093\000\000\000\
\\014\000\152\000\015\000\095\000\025\000\151\000\026\000\194\000\
\\028\000\093\000\000\000\
\\025\000\195\000\028\000\093\000\000\000\
\\025\000\197\000\028\000\093\000\000\000\
\\000\000\
\\014\000\200\000\015\000\095\000\025\000\094\000\028\000\093\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\008\000\052\000\013\000\051\000\016\000\203\000\000\000\
\\007\000\204\000\000\000\
\\008\000\052\000\012\000\206\000\013\000\051\000\016\000\205\000\000\000\
\\010\000\208\000\014\000\207\000\015\000\095\000\025\000\094\000\
\\028\000\093\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\025\000\210\000\028\000\093\000\000\000\
\\000\000\
\\025\000\211\000\028\000\093\000\000\000\
\\014\000\212\000\015\000\095\000\025\000\094\000\028\000\093\000\000\000\
\\000\000\
\\000\000\
\\024\000\213\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\011\000\217\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\014\000\219\000\015\000\095\000\023\000\218\000\025\000\094\000\
\\028\000\093\000\000\000\
\\000\000\
\\008\000\052\000\012\000\222\000\013\000\051\000\016\000\205\000\000\000\
\\010\000\223\000\014\000\207\000\015\000\095\000\025\000\094\000\
\\028\000\093\000\000\000\
\\007\000\224\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\020\000\226\000\021\000\157\000\022\000\156\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\020\000\227\000\021\000\157\000\022\000\156\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 230
val numrules = 104
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; ordof(!s,i) + ordof(!s,i+1) * 256
end
val string_to_list = fn s' =>
    let val len = String.length s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.length s'
 	 fun f ()=
	    if !index < len then convert_row() :: f()
	    else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
	fun f i =
	     if i=numstates then g i
	     else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
	   in f 0 handle Subscript => ()
	   end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.arrayoflist(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.arrayoflist(actionRows) in fn i=>Array.sub(a,i) end
in Array.arrayoflist(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = int
type arg = unit
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit | FILE of  (string)
 | VAR of  (string) | ID of  (string) | INTEGER of  (int)
 | int of  (int) | tag of  (tag) | boolexp of  (boolexp)
 | arexpr of  (arexpr) | query_list of  (query list)
 | query of  (query) | from_do_list of  (from_do list)
 | from_do of  (from_do) | instruction of  (instruction)
 | body_list of  ( ( cell * instruction )  list)
 | body of  (cell*instruction) | algo_decl of  (algo)
 | event_list of  (state) | interval of  (value) | value of  (value)
 | event of  (event) | enabling of  (access list)
 | access_list of  (access list) | value_list of  (value list)
 | ext_cell_name of  (cell) | cell_name of  (cell)
 | component of  (component list) | dcds_decl of  (dcds)
 | dcds_decla of  (dcds_tree) | name_list of  (string list)
 | command of  (command_tree) | expr of  (expr) | prog of  (ParseTree)
end
type svalue = MlyValue.svalue
type result = ParseTree
end
structure EC=
struct
open LrTable
val is_keyword =
fn (T 62) => true | (T 59) => true | (T 58) => true | (T 57) => true
 | (T 56) => true | (T 55) => true | (T 54) => true | (T 45) => true
 | (T 44) => true | (T 51) => true | (T 40) => true | (T 39) => true
 | (T 38) => true | (T 37) => true | (T 43) => true | (T 42) => true
 | (T 41) => true | (T 28) => true | (T 27) => true | (T 25) => true
 | (T 24) => true | (T 21) => true | (T 20) => true | (T 19) => true
 | (T 18) => true | (T 14) => true | (T 12) => true | (T 11) => true
 | (T 8) => true | (T 6) => true | (T 4) => true | (T 3) => true | (T 
0) => true | _ => false
val preferred_insert =
fn _ => false
val preferred_subst =
fn  _ => nil
val noShift = 
fn (T 17) => true | _ => false
val showTerminal =
fn (T 0) => "LET"
  | (T 1) => "LETREC"
  | (T 2) => "EQ"
  | (T 3) => "DCDS"
  | (T 4) => "END"
  | (T 5) => "SEMI"
  | (T 6) => "CELL"
  | (T 7) => "INTEGER"
  | (T 8) => "GRAFT"
  | (T 9) => "APPLY"
  | (T 10) => "COMMA"
  | (T 11) => "ACCESS"
  | (T 12) => "OR"
  | (T 13) => "AND"
  | (T 14) => "ALGO"
  | (T 15) => "ID"
  | (T 16) => "VAR"
  | (T 17) => "EOF"
  | (T 18) => "VALUES"
  | (T 19) => "REQUEST"
  | (T 20) => "DO"
  | (T 21) => "FROM"
  | (T 22) => "LC"
  | (T 23) => "RC"
  | (T 24) => "VALOF"
  | (T 25) => "IS"
  | (T 26) => "COLON"
  | (T 27) => "OUTPUT"
  | (T 28) => "WITH"
  | (T 29) => "COMPOSE"
  | (T 30) => "LA"
  | (T 31) => "RA"
  | (T 32) => "LB"
  | (T 33) => "RB"
  | (T 34) => "LS"
  | (T 35) => "RS"
  | (T 36) => "MINUS"
  | (T 37) => "TIMER"
  | (T 38) => "TRACE"
  | (T 39) => "ON"
  | (T 40) => "OFF"
  | (T 41) => "CURRY"
  | (T 42) => "UNCURRY"
  | (T 43) => "FIX"
  | (T 44) => "LOAD"
  | (T 45) => "LOADECHO"
  | (T 46) => "PRINT"
  | (T 47) => "PLUS"
  | (T 48) => "SUB"
  | (T 49) => "MULT"
  | (T 50) => "DIV"
  | (T 51) => "OMEGA"
  | (T 52) => "BANG"
  | (T 53) => "FILE"
  | (T 54) => "ENV"
  | (T 55) => "TYPING"
  | (T 56) => "SHOW"
  | (T 57) => "MORE"
  | (T 58) => "HIERARCHY"
  | (T 59) => "PCF"
  | (T 60) => "LOCAL"
  | (T 61) => "IN"
  | (T 62) => "REFINE"
  | _ => "bogus-term"
val errtermvalue=
let open Header in
fn _ => MlyValue.VOID
end
val terms = (T 0) :: (T 1) :: (T 2) :: (T 3) :: (T 4) :: (T 5) :: (T 6
) :: (T 8) :: (T 9) :: (T 10) :: (T 11) :: (T 12) :: (T 13) :: (T 14)
 :: (T 17) :: (T 18) :: (T 19) :: (T 20) :: (T 21) :: (T 22) :: (T 23)
 :: (T 24) :: (T 25) :: (T 26) :: (T 27) :: (T 28) :: (T 29) :: (T 30)
 :: (T 31) :: (T 32) :: (T 33) :: (T 34) :: (T 35) :: (T 36) :: (T 37)
 :: (T 38) :: (T 39) :: (T 40) :: (T 41) :: (T 42) :: (T 43) :: (T 44)
 :: (T 45) :: (T 46) :: (T 47) :: (T 48) :: (T 49) :: (T 50) :: (T 51)
 :: (T 52) :: (T 54) :: (T 55) :: (T 56) :: (T 57) :: (T 58) :: (T 59)
 :: (T 60) :: (T 61) :: (T 62) :: nil
end
structure Actions =
struct 
exception mlyAction of int
val actions = 
let open Header
in
fn (i392,defaultPos,stack,
    (()):arg) =>
case (i392,stack)
of (0,rest671) => let val result=MlyValue.prog((EMPTY))
 in (LrTable.NT 0,(result,defaultPos,defaultPos),rest671) end
| (1,(_,(MlyValue.expr expr,expr1left,expr1right))::rest671) => let 
val result=MlyValue.prog((EXP expr))
 in (LrTable.NT 0,(result,expr1left,expr1right),rest671) end
| (2,(_,(MlyValue.command command,command1left,command1right))::
rest671) => let val result=MlyValue.prog((COM command))
 in (LrTable.NT 0,(result,command1left,command1right),rest671) end
| (3,(_,(MlyValue.dcds_decla dcds_decla,dcds_decla1left,
dcds_decla1right))::rest671) => let val result=MlyValue.prog((
DCDS dcds_decla))
 in (LrTable.NT 0,(result,dcds_decla1left,dcds_decla1right),rest671)
 end
| (4,(_,(_,_,RC1right))::(_,(MlyValue.event_list event_list,_,_))::(_,
(_,LC1left,_))::rest671) => let val result=MlyValue.expr((
Expr_state event_list))
 in (LrTable.NT 1,(result,LC1left,RC1right),rest671) end
| (5,(_,(MlyValue.algo_decl algo_decl,algo_decl1left,algo_decl1right))
::rest671) => let val result=MlyValue.expr((Expr_algo algo_decl))
 in (LrTable.NT 1,(result,algo_decl1left,algo_decl1right),rest671) end
| (6,(_,(_,_,RB1right))::(_,(MlyValue.expr expr,_,_))::_::(_,(_,
CURRY1left,_))::rest671) => let val result=MlyValue.expr((
Expr_curry expr))
 in (LrTable.NT 1,(result,CURRY1left,RB1right),rest671) end
| (7,(_,(_,_,RB1right))::(_,(MlyValue.expr expr,_,_))::_::(_,(_,
UNCURRY1left,_))::rest671) => let val result=MlyValue.expr((
Expr_uncurry expr))
 in (LrTable.NT 1,(result,UNCURRY1left,RB1right),rest671) end
| (8,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.expr((
Expr_compose(expr1, expr2)))
 in (LrTable.NT 1,(result,expr1left,expr2right),rest671) end
| (9,(_,(MlyValue.expr expr2,_,expr2right))::_::(_,(MlyValue.expr 
expr1,expr1left,_))::rest671) => let val result=MlyValue.expr((
Expr_apply(expr1, expr2)))
 in (LrTable.NT 1,(result,expr1left,expr2right),rest671) end
| (10,(_,(_,_,RA1right))::(_,(MlyValue.expr expr2,_,_))::_::(_,(
MlyValue.expr expr1,_,_))::(_,(_,LA1left,_))::rest671) => let val 
result=MlyValue.expr((Expr_pair(expr1, expr2)))
 in (LrTable.NT 1,(result,LA1left,RA1right),rest671) end
| (11,(_,(_,_,RB1right))::(_,(MlyValue.expr expr2,_,_))::_::(_,(
MlyValue.expr expr1,_,_))::(_,(_,LB1left,_))::rest671) => let val 
result=MlyValue.expr((Expr_prod(expr1, expr2)))
 in (LrTable.NT 1,(result,LB1left,RB1right),rest671) end
| (12,(_,(_,_,RB1right))::(_,(MlyValue.expr expr,_,_))::_::(_,(_,
FIX1left,_))::rest671) => let val result=MlyValue.expr((Expr_fix expr)
)
 in (LrTable.NT 1,(result,FIX1left,RB1right),rest671) end
| (13,(_,(_,_,RB1right))::(_,(MlyValue.expr expr,_,_))::(_,(_,LB1left,
_))::rest671) => let val result=MlyValue.expr((expr))
 in (LrTable.NT 1,(result,LB1left,RB1right),rest671) end
| (14,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val 
result=MlyValue.expr((Expr_id ID))
 in (LrTable.NT 1,(result,ID1left,ID1right),rest671) end
| (15,(_,(MlyValue.expr expr,_,expr1right))::_::(_,(MlyValue.ID ID,_,_
))::(_,(_,LET1left,_))::rest671) => let val result=MlyValue.command((
Com_abbreviate(ID, expr)))
 in (LrTable.NT 2,(result,LET1left,expr1right),rest671) end
| (16,(_,(MlyValue.ID ID,_,ID1right))::(_,(_,PRINT1left,_))::rest671)
 => let val result=MlyValue.command((Com_print ID))
 in (LrTable.NT 2,(result,PRINT1left,ID1right),rest671) end
| (17,(_,(MlyValue.FILE FILE,_,FILE1right))::(_,(_,LOAD1left,_))::
rest671) => let val result=MlyValue.command((Com_load FILE))
 in (LrTable.NT 2,(result,LOAD1left,FILE1right),rest671) end
| (18,(_,(MlyValue.FILE FILE,_,FILE1right))::(_,(_,LOADECHO1left,_))::
rest671) => let val result=MlyValue.command((Com_loadecho FILE))
 in (LrTable.NT 2,(result,LOADECHO1left,FILE1right),rest671) end
| (19,(_,(_,_,ON1right))::(_,(_,TRACE1left,_))::rest671) => let val 
result=MlyValue.command((Com_traceon))
 in (LrTable.NT 2,(result,TRACE1left,ON1right),rest671) end
| (20,(_,(_,_,OFF1right))::(_,(_,TRACE1left,_))::rest671) => let val 
result=MlyValue.command((Com_traceoff))
 in (LrTable.NT 2,(result,TRACE1left,OFF1right),rest671) end
| (21,(_,(_,_,ON1right))::(_,(_,TIMER1left,_))::rest671) => let val 
result=MlyValue.command((Com_timeron))
 in (LrTable.NT 2,(result,TIMER1left,ON1right),rest671) end
| (22,(_,(_,_,OFF1right))::(_,(_,TIMER1left,_))::rest671) => let val 
result=MlyValue.command((Com_timeroff))
 in (LrTable.NT 2,(result,TIMER1left,OFF1right),rest671) end
| (23,(_,(_,_,ON1right))::(_,(_,TYPING1left,_))::rest671) => let val 
result=MlyValue.command((Com_typingon))
 in (LrTable.NT 2,(result,TYPING1left,ON1right),rest671) end
| (24,(_,(_,_,OFF1right))::(_,(_,TYPING1left,_))::rest671) => let val 
result=MlyValue.command((Com_typingoff))
 in (LrTable.NT 2,(result,TYPING1left,OFF1right),rest671) end
| (25,(_,(MlyValue.ID ID,_,ID1right))::(_,(MlyValue.INTEGER INTEGER,_,
_))::(_,(_,SHOW1left,_))::rest671) => let val result=MlyValue.command(
(Com_show(INTEGER, ID)))
 in (LrTable.NT 2,(result,SHOW1left,ID1right),rest671) end
| (26,(_,(MlyValue.ID ID,_,ID1right))::(_,(MlyValue.INTEGER INTEGER,_,
_))::_::(_,(_,SHOW1left,_))::rest671) => let val result=
MlyValue.command((Com_show_more(INTEGER, ID)))
 in (LrTable.NT 2,(result,SHOW1left,ID1right),rest671) end
| (27,(_,(MlyValue.FILE FILE,_,FILE1right))::(_,(_,HIERARCHY1left,_))
::rest671) => let val result=MlyValue.command((Com_hierarchy FILE))
 in (LrTable.NT 2,(result,HIERARCHY1left,FILE1right),rest671) end
| (28,(_,(_,ENV1left,ENV1right))::rest671) => let val result=
MlyValue.command((Com_env))
 in (LrTable.NT 2,(result,ENV1left,ENV1right),rest671) end
| (29,(_,(_,PCF1left,PCF1right))::rest671) => let val result=
MlyValue.command((Com_PCF))
 in (LrTable.NT 2,(result,PCF1left,PCF1right),rest671) end
| (30,(_,(MlyValue.name_list name_list,_,name_list1right))::(_,(_,
REFINE1left,_))::rest671) => let val result=MlyValue.command((
Com_refine name_list))
 in (LrTable.NT 2,(result,REFINE1left,name_list1right),rest671) end
| (31,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val 
result=MlyValue.name_list(([ID]))
 in (LrTable.NT 3,(result,ID1left,ID1right),rest671) end
| (32,(_,(MlyValue.name_list name_list,_,name_list1right))::_::(_,(
MlyValue.ID ID,ID1left,_))::rest671) => let val result=
MlyValue.name_list((ID :: name_list))
 in (LrTable.NT 3,(result,ID1left,name_list1right),rest671) end
| (33,(_,(MlyValue.dcds_decl dcds_decl,_,dcds_decl1right))::(_,(_,
LETREC1left,_))::rest671) => let val result=MlyValue.dcds_decla((
Recursive dcds_decl))
 in (LrTable.NT 4,(result,LETREC1left,dcds_decl1right),rest671) end
| (34,(_,(MlyValue.dcds_decl dcds_decl,_,dcds_decl1right))::(_,(_,
LET1left,_))::rest671) => let val result=MlyValue.dcds_decla((
Normal dcds_decl))
 in (LrTable.NT 4,(result,LET1left,dcds_decl1right),rest671) end
| (35,(_,(_,_,END1right))::(_,(MlyValue.dcds_decla dcds_decla2,_,_))::
_::(_,(MlyValue.dcds_decla dcds_decla1,_,_))::(_,(_,LOCAL1left,_))::
rest671) => let val result=MlyValue.dcds_decla((
Local(dcds_decla1,dcds_decla2)))
 in (LrTable.NT 4,(result,LOCAL1left,END1right),rest671) end
| (36,(_,(_,_,END1right))::(_,(MlyValue.component component,_,_))::_::
_::(_,(MlyValue.ID ID,ID1left,_))::rest671) => let val result=
MlyValue.dcds_decl(((ID, component)))
 in (LrTable.NT 5,(result,ID1left,END1right),rest671) end
| (37,rest671) => let val result=MlyValue.component(([]))
 in (LrTable.NT 6,(result,defaultPos,defaultPos),rest671) end
| (38,(_,(MlyValue.component component,_,component1right))::(_,(
MlyValue.access_list access_list,_,_))::(_,(MlyValue.value_list 
value_list,_,_))::_::(_,(MlyValue.cell_name cell_name,_,_))::(_,(_,
CELL1left,_))::rest671) => let val result=MlyValue.component((
Comp_cell (cell_name, value_list, access_list) :: component))
 in (LrTable.NT 6,(result,CELL1left,component1right),rest671) end
| (39,(_,(MlyValue.component component,_,component1right))::(_,(
MlyValue.access_list access_list,_,_))::(_,(MlyValue.cell_name 
cell_name,_,_))::(_,(_,GRAFT1left,_))::rest671) => let val result=
MlyValue.component((Comp_graft (cell_name, access_list) :: component))
 in (LrTable.NT 6,(result,GRAFT1left,component1right),rest671) end
| (40,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val 
result=MlyValue.cell_name((Cell_name ID))
 in (LrTable.NT 7,(result,ID1left,ID1right),rest671) end
| (41,(_,(MlyValue.VAR VAR,VAR1left,VAR1right))::rest671) => let val 
result=MlyValue.cell_name((Cell_var VAR))
 in (LrTable.NT 7,(result,VAR1left,VAR1right),rest671) end
| (42,(_,(MlyValue.cell_name cell_name,_,cell_name1right))::_::(_,(
MlyValue.event_list event_list,_,_))::(_,(_,LC1left,_))::rest671) => 
let val result=MlyValue.cell_name((
Cell_fun (Expr_state event_list, cell_name)))
 in (LrTable.NT 7,(result,LC1left,cell_name1right),rest671) end
| (43,(_,(_,_,RB1right))::(_,(MlyValue.tag tag,_,_))::_::(_,(
MlyValue.cell_name cell_name,_,_))::(_,(_,LB1left,_))::rest671) => 
let val result=MlyValue.cell_name((Cell_graft (cell_name, tag)))
 in (LrTable.NT 7,(result,LB1left,RB1right),rest671) end
| (44,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val 
result=MlyValue.tag((Tag_str ID))
 in (LrTable.NT 26,(result,ID1left,ID1right),rest671) end
| (45,(_,(MlyValue.arexpr arexpr,arexpr1left,arexpr1right))::rest671)
 => let val result=MlyValue.tag((Tag_arexpr arexpr))
 in (LrTable.NT 26,(result,arexpr1left,arexpr1right),rest671) end
| (46,(_,(MlyValue.interval interval,interval1left,interval1right))::
rest671) => let val result=MlyValue.tag((Tag_interval interval))
 in (LrTable.NT 26,(result,interval1left,interval1right),rest671) end
| (47,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val 
result=MlyValue.value((Val_string ID))
 in (LrTable.NT 13,(result,ID1left,ID1right),rest671) end
| (48,(_,(MlyValue.cell_name cell_name,_,cell_name1right))::(_,(_,
VALOF1left,_))::rest671) => let val result=MlyValue.value((
Val_valof cell_name))
 in (LrTable.NT 13,(result,VALOF1left,cell_name1right),rest671) end
| (49,(_,(MlyValue.value value,_,value1right))::(_,(_,OUTPUT1left,_))
::rest671) => let val result=MlyValue.value((Val_output value))
 in (LrTable.NT 13,(result,OUTPUT1left,value1right),rest671) end
| (50,(_,(MlyValue.arexpr arexpr,arexpr1left,arexpr1right))::rest671)
 => let val result=MlyValue.value((Val_arexpr arexpr))
 in (LrTable.NT 13,(result,arexpr1left,arexpr1right),rest671) end
| (51,(_,(_,_,RB1right))::(_,(MlyValue.value value2,_,_))::_::(_,(
MlyValue.value value1,_,_))::(_,(_,LB1left,_))::rest671) => let val 
result=MlyValue.value((Val_pair (value1, value2)))
 in (LrTable.NT 13,(result,LB1left,RB1right),rest671) end
| (52,(_,(MlyValue.boolexp boolexp,_,boolexp1right))::_::(_,(
MlyValue.VAR VAR,VAR1left,_))::rest671) => let val result=
MlyValue.value((Val_with (VAR, boolexp)))
 in (LrTable.NT 13,(result,VAR1left,boolexp1right),rest671) end
| (53,(_,(MlyValue.interval interval,interval1left,interval1right))::
rest671) => let val result=MlyValue.value((interval))
 in (LrTable.NT 13,(result,interval1left,interval1right),rest671) end
| (54,(_,(_,_,RS1right))::_::_::(_,(_,LS1left,_))::rest671) => let 
val result=MlyValue.interval((Val_interval_inf))
 in (LrTable.NT 14,(result,LS1left,RS1right),rest671) end
| (55,(_,(_,_,RS1right))::_::_::(_,(MlyValue.int int,_,_))::(_,(_,
LS1left,_))::rest671) => let val result=MlyValue.interval((
Val_interval_from int))
 in (LrTable.NT 14,(result,LS1left,RS1right),rest671) end
| (56,(_,(_,_,RS1right))::(_,(MlyValue.int int,_,_))::_::_::(_,(_,
LS1left,_))::rest671) => let val result=MlyValue.interval((
Val_interval_to int))
 in (LrTable.NT 14,(result,LS1left,RS1right),rest671) end
| (57,(_,(_,_,RS1right))::(_,(MlyValue.int int2,_,_))::_::_::(_,(
MlyValue.int int1,_,_))::(_,(_,LS1left,_))::rest671) => let val result
=MlyValue.interval((Val_interval_fromto(int1,int2)))
 in (LrTable.NT 14,(result,LS1left,RS1right),rest671) end
| (58,(_,(MlyValue.INTEGER INTEGER,INTEGER1left,INTEGER1right))::
rest671) => let val result=MlyValue.int((INTEGER))
 in (LrTable.NT 27,(result,INTEGER1left,INTEGER1right),rest671) end
| (59,(_,(MlyValue.INTEGER INTEGER,_,INTEGER1right))::(_,(_,MINUS1left
,_))::rest671) => let val result=MlyValue.int((~INTEGER))
 in (LrTable.NT 27,(result,MINUS1left,INTEGER1right),rest671) end
| (60,(_,(MlyValue.value value,value1left,value1right))::rest671) => 
let val result=MlyValue.value_list(([value]))
 in (LrTable.NT 9,(result,value1left,value1right),rest671) end
| (61,(_,(MlyValue.value_list value_list,_,value_list1right))::_::(_,(
MlyValue.value value,value1left,_))::rest671) => let val result=
MlyValue.value_list(([value] @ value_list))
 in (LrTable.NT 9,(result,value1left,value_list1right),rest671) end
| (62,rest671) => let val result=MlyValue.access_list(([]))
 in (LrTable.NT 10,(result,defaultPos,defaultPos),rest671) end
| (63,(_,(MlyValue.enabling enabling,_,enabling1right))::(_,(_,
ACCESS1left,_))::rest671) => let val result=MlyValue.access_list((
enabling))
 in (LrTable.NT 10,(result,ACCESS1left,enabling1right),rest671) end
| (64,(_,(MlyValue.event_list event_list,event_list1left,
event_list1right))::rest671) => let val result=MlyValue.enabling((
[event_list]))
 in (LrTable.NT 11,(result,event_list1left,event_list1right),rest671)
 end
| (65,(_,(MlyValue.enabling enabling,_,enabling1right))::_::(_,(
MlyValue.event_list event_list,event_list1left,_))::rest671) => let 
val result=MlyValue.enabling((event_list :: enabling))
 in (LrTable.NT 11,(result,event_list1left,enabling1right),rest671)
 end
| (66,rest671) => let val result=MlyValue.event_list(([]))
 in (LrTable.NT 15,(result,defaultPos,defaultPos),rest671) end
| (67,(_,(MlyValue.event event,event1left,event1right))::rest671) => 
let val result=MlyValue.event_list(([event]))
 in (LrTable.NT 15,(result,event1left,event1right),rest671) end
| (68,(_,(MlyValue.event_list event_list,_,event_list1right))::_::(_,(
MlyValue.event event,event1left,_))::rest671) => let val result=
MlyValue.event_list((event :: event_list))
 in (LrTable.NT 15,(result,event1left,event_list1right),rest671) end
| (69,(_,(MlyValue.value value,_,value1right))::_::(_,(
MlyValue.cell_name cell_name,cell_name1left,_))::rest671) => let val 
result=MlyValue.event(((cell_name, value)))
 in (LrTable.NT 12,(result,cell_name1left,value1right),rest671) end
| (70,(_,(MlyValue.int int,int1left,int1right))::rest671) => let val 
result=MlyValue.arexpr((Arexpr_int int))
 in (LrTable.NT 24,(result,int1left,int1right),rest671) end
| (71,(_,(MlyValue.VAR VAR,VAR1left,VAR1right))::rest671) => let val 
result=MlyValue.arexpr((Arexpr_var VAR))
 in (LrTable.NT 24,(result,VAR1left,VAR1right),rest671) end
| (72,(_,(MlyValue.VAR VAR,_,VAR1right))::(_,(_,MINUS1left,_))::
rest671) => let val result=MlyValue.arexpr((
Arexpr_minus (Arexpr_var VAR)))
 in (LrTable.NT 24,(result,MINUS1left,VAR1right),rest671) end
| (73,(_,(_,_,RB1right))::(_,(MlyValue.arexpr arexpr,_,_))::_::(_,(_,
MINUS1left,_))::rest671) => let val result=MlyValue.arexpr((
Arexpr_minus arexpr))
 in (LrTable.NT 24,(result,MINUS1left,RB1right),rest671) end
| (74,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.arexpr((Arexpr_plus (arexpr1, arexpr2)))
 in (LrTable.NT 24,(result,arexpr1left,arexpr2right),rest671) end
| (75,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.arexpr((Arexpr_sub (arexpr1, arexpr2)))
 in (LrTable.NT 24,(result,arexpr1left,arexpr2right),rest671) end
| (76,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.arexpr((Arexpr_mult (arexpr1, arexpr2)))
 in (LrTable.NT 24,(result,arexpr1left,arexpr2right),rest671) end
| (77,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.arexpr((Arexpr_div (arexpr1, arexpr2)))
 in (LrTable.NT 24,(result,arexpr1left,arexpr2right),rest671) end
| (78,(_,(_,_,RB1right))::(_,(MlyValue.arexpr arexpr,_,_))::(_,(_,
LB1left,_))::rest671) => let val result=MlyValue.arexpr((arexpr))
 in (LrTable.NT 24,(result,LB1left,RB1right),rest671) end
| (79,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.boolexp((Boolexp_gt (arexpr1, arexpr2)))
 in (LrTable.NT 25,(result,arexpr1left,arexpr2right),rest671) end
| (80,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.boolexp((Boolexp_gteq (arexpr1, arexpr2)))
 in (LrTable.NT 25,(result,arexpr1left,arexpr2right),rest671) end
| (81,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.boolexp((Boolexp_lt (arexpr1, arexpr2)))
 in (LrTable.NT 25,(result,arexpr1left,arexpr2right),rest671) end
| (82,(_,(MlyValue.arexpr arexpr2,_,arexpr2right))::_::_::(_,(
MlyValue.arexpr arexpr1,arexpr1left,_))::rest671) => let val result=
MlyValue.boolexp((Boolexp_lteq (arexpr1, arexpr2)))
 in (LrTable.NT 25,(result,arexpr1left,arexpr2right),rest671) end
| (83,(_,(MlyValue.value value2,_,value2right))::_::(_,(MlyValue.value
 value1,value1left,_))::rest671) => let val result=MlyValue.boolexp((
Boolexp_eq (value1, value2)))
 in (LrTable.NT 25,(result,value1left,value2right),rest671) end
| (84,(_,(MlyValue.value value2,_,value2right))::_::_::(_,(
MlyValue.value value1,value1left,_))::rest671) => let val result=
MlyValue.boolexp((Boolexp_noteq (value1, value2)))
 in (LrTable.NT 25,(result,value1left,value2right),rest671) end
| (85,(_,(MlyValue.boolexp boolexp2,_,boolexp2right))::_::(_,(
MlyValue.boolexp boolexp1,boolexp1left,_))::rest671) => let val result
=MlyValue.boolexp((Boolexp_or (boolexp1, boolexp2)))
 in (LrTable.NT 25,(result,boolexp1left,boolexp2right),rest671) end
| (86,(_,(MlyValue.boolexp boolexp2,_,boolexp2right))::_::(_,(
MlyValue.boolexp boolexp1,boolexp1left,_))::rest671) => let val result
=MlyValue.boolexp((Boolexp_and (boolexp1, boolexp2)))
 in (LrTable.NT 25,(result,boolexp1left,boolexp2right),rest671) end
| (87,(_,(_,_,RB1right))::(_,(MlyValue.boolexp boolexp,_,_))::(_,(_,
LB1left,_))::rest671) => let val result=MlyValue.boolexp((boolexp))
 in (LrTable.NT 25,(result,LB1left,RB1right),rest671) end
| (88,(_,(_,_,END1right))::(_,(MlyValue.body_list body_list,_,_))::(_,
(_,ALGO1left,_))::rest671) => let val result=MlyValue.algo_decl((
rev body_list))
 in (LrTable.NT 16,(result,ALGO1left,END1right),rest671) end
| (89,rest671) => let val result=MlyValue.body_list(([]))
 in (LrTable.NT 18,(result,defaultPos,defaultPos),rest671) end
| (90,(_,(MlyValue.body body,_,body1right))::(_,(MlyValue.body_list 
body_list,body_list1left,_))::rest671) => let val result=
MlyValue.body_list((body :: body_list))
 in (LrTable.NT 18,(result,body_list1left,body1right),rest671) end
| (91,(_,(_,_,END1right))::(_,(MlyValue.instruction instruction,_,_))
::_::(_,(MlyValue.ext_cell_name ext_cell_name,_,_))::(_,(_,
REQUEST1left,_))::rest671) => let val result=MlyValue.body((
(ext_cell_name, instruction)))
 in (LrTable.NT 17,(result,REQUEST1left,END1right),rest671) end
| (92,(_,(MlyValue.cell_name cell_name,cell_name1left,cell_name1right)
)::rest671) => let val result=MlyValue.ext_cell_name((cell_name))
 in (LrTable.NT 8,(result,cell_name1left,cell_name1right),rest671) end
| (93,(_,(MlyValue.boolexp boolexp,_,boolexp1right))::_::(_,(
MlyValue.cell_name cell_name,cell_name1left,_))::rest671) => let val 
result=MlyValue.ext_cell_name((Cell_with (cell_name, boolexp)))
 in (LrTable.NT 8,(result,cell_name1left,boolexp1right),rest671) end
| (94,(_,(MlyValue.value value,_,value1right))::(_,(_,OUTPUT1left,_))
::rest671) => let val result=MlyValue.instruction((Ins_output value))
 in (LrTable.NT 19,(result,OUTPUT1left,value1right),rest671) end
| (95,(_,(_,_,END1right))::(_,(MlyValue.query_list query_list,_,_))::_
::(_,(MlyValue.cell_name cell_name,_,_))::(_,(_,VALOF1left,_))::
rest671) => let val result=MlyValue.instruction((
Ins_valof(cell_name, rev query_list)))
 in (LrTable.NT 19,(result,VALOF1left,END1right),rest671) end
| (96,(_,(MlyValue.from_do_list from_do_list,from_do_list1left,
from_do_list1right))::rest671) => let val result=MlyValue.instruction(
(Ins_from (rev from_do_list)))
 in (LrTable.NT 19,(result,from_do_list1left,from_do_list1right),
rest671) end
| (97,(_,(_,OMEGA1left,OMEGA1right))::rest671) => let val result=
MlyValue.instruction((Ins_omega))
 in (LrTable.NT 19,(result,OMEGA1left,OMEGA1right),rest671) end
| (98,(_,(MlyValue.from_do from_do,from_do1left,from_do1right))::
rest671) => let val result=MlyValue.from_do_list(([from_do]))
 in (LrTable.NT 21,(result,from_do1left,from_do1right),rest671) end
| (99,(_,(MlyValue.from_do from_do,_,from_do1right))::(_,(
MlyValue.from_do_list from_do_list,from_do_list1left,_))::rest671) => 
let val result=MlyValue.from_do_list(([from_do] @ from_do_list))
 in (LrTable.NT 21,(result,from_do_list1left,from_do1right),rest671)
 end
| (100,(_,(_,_,END1right))::(_,(MlyValue.instruction instruction,_,_))
::_::_::(_,(MlyValue.event_list event_list,_,_))::_::(_,(_,FROM1left,_
))::rest671) => let val result=MlyValue.from_do((
(event_list, instruction)))
 in (LrTable.NT 20,(result,FROM1left,END1right),rest671) end
| (101,(_,(MlyValue.instruction instruction,_,instruction1right))::_::
(_,(MlyValue.value value,value1left,_))::rest671) => let val result=
MlyValue.query(((value, instruction)))
 in (LrTable.NT 22,(result,value1left,instruction1right),rest671) end
| (102,rest671) => let val result=MlyValue.query_list(([]))
 in (LrTable.NT 23,(result,defaultPos,defaultPos),rest671) end
| (103,(_,(MlyValue.query query,_,query1right))::(_,(
MlyValue.query_list query_list,query_list1left,_))::rest671) => let 
val result=MlyValue.query_list((query :: query_list))
 in (LrTable.NT 23,(result,query_list1left,query1right),rest671) end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.prog x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a 
end
end
structure Tokens : CDS_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun LET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID,p1,p2))
fun LETREC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.VOID,p1,p2))
fun EQ (p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.VOID,p1,p2))
fun DCDS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.VOID,p1,p2))
fun END (p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.VOID,p1,p2))
fun SEMI (p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.VOID,p1,p2))
fun CELL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.VOID,p1,p2))
fun INTEGER (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.INTEGER i,p1,p2))
fun GRAFT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.VOID,p1,p2))
fun APPLY (p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.VOID,p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.VOID,p1,p2))
fun ACCESS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID,p1,p2))
fun OR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun ALGO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.ID i,p1,p2))
fun VAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VAR i,p1,p2))
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID,p1,p2))
fun VALUES (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID,p1,p2))
fun REQUEST (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun DO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun FROM (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun LC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun RC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun VALOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun IS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun COLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID,p1,p2))
fun OUTPUT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun WITH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun COMPOSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun LA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID,p1,p2))
fun RA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID,p1,p2))
fun LB (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.VOID,p1,p2))
fun RB (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID,p1,p2))
fun LS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.VOID,p1,p2))
fun RS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID,p1,p2))
fun MINUS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.VOID,p1,p2))
fun TIMER (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.VOID,p1,p2))
fun TRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.VOID,p1,p2))
fun ON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID,p1,p2))
fun OFF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.VOID,p1,p2))
fun CURRY (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(
ParserData.MlyValue.VOID,p1,p2))
fun UNCURRY (p1,p2) = Token.TOKEN (ParserData.LrTable.T 42,(
ParserData.MlyValue.VOID,p1,p2))
fun FIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 43,(
ParserData.MlyValue.VOID,p1,p2))
fun LOAD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 44,(
ParserData.MlyValue.VOID,p1,p2))
fun LOADECHO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 45,(
ParserData.MlyValue.VOID,p1,p2))
fun PRINT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 46,(
ParserData.MlyValue.VOID,p1,p2))
fun PLUS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 47,(
ParserData.MlyValue.VOID,p1,p2))
fun SUB (p1,p2) = Token.TOKEN (ParserData.LrTable.T 48,(
ParserData.MlyValue.VOID,p1,p2))
fun MULT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 49,(
ParserData.MlyValue.VOID,p1,p2))
fun DIV (p1,p2) = Token.TOKEN (ParserData.LrTable.T 50,(
ParserData.MlyValue.VOID,p1,p2))
fun OMEGA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 51,(
ParserData.MlyValue.VOID,p1,p2))
fun BANG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 52,(
ParserData.MlyValue.VOID,p1,p2))
fun FILE (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 53,(
ParserData.MlyValue.FILE i,p1,p2))
fun ENV (p1,p2) = Token.TOKEN (ParserData.LrTable.T 54,(
ParserData.MlyValue.VOID,p1,p2))
fun TYPING (p1,p2) = Token.TOKEN (ParserData.LrTable.T 55,(
ParserData.MlyValue.VOID,p1,p2))
fun SHOW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 56,(
ParserData.MlyValue.VOID,p1,p2))
fun MORE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 57,(
ParserData.MlyValue.VOID,p1,p2))
fun HIERARCHY (p1,p2) = Token.TOKEN (ParserData.LrTable.T 58,(
ParserData.MlyValue.VOID,p1,p2))
fun PCF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 59,(
ParserData.MlyValue.VOID,p1,p2))
fun LOCAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 60,(
ParserData.MlyValue.VOID,p1,p2))
fun IN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 61,(
ParserData.MlyValue.VOID,p1,p2))
fun REFINE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 62,(
ParserData.MlyValue.VOID,p1,p2))
end
end
