#!/bin/sh

TMP=`mktemp`
cat coloring.pl coloring_tests.pl > ${TMP}

if [ -f /afs/andrew/course/15/317/bin/runprolog ]; then
	echo "Running GNU-Prolog on AFS"
    PATH="/afs/andrew/course/15/317/bin" gprolog --consult-file ${TMP} --query-goal result
elif type "swipl" > /dev/null; then
	echo "Running SWI-Prolog on local machine"
    swipl -f ${TMP} -g result
else
	echo "Running GNU-Prolog on local machine"
	gprolog --consult-file ${TMP} --query-goal result
fi

echo "If you get existence error in GNU-Prolog, please consider installing SWI-Prolog"
echo "To install SWI-Prolog on Ubuntu, run the following command"
echo "   $ sudo apt install swi-prolog"
echo "To install SWI-Prolog on Mac, run the following command"
echo "   $ brew install swi-prolog"

rm ${TMP}
