structure Printing = struct

  local
    val installers : (unit -> unit) list ref = ref []
    fun make_installer (name, to_string) () = CompilerPPTable.install_pp [name, "Logic", "proof"] (fn s => fn p => PrettyPrint.string s (to_string p))
  in

    fun register (name, to_string) = installers :=  make_installer (name, to_string) :: !installers
    fun activate () = (
      List.app (fn x => x ()) (!installers);
      installers := []
    )
  end

  fun context_to_string p2s gamma = case gamma of
      [] => "•"
    | _ => String.concatWithMap ", " p2s gamma
  
  local
    structure String = struct open String
      fun size str =
        let
          exception MalformedCode
          fun aux false [] = []
            | aux false (#"\027"::cs) = aux true cs
            | aux false (c::cs) = c :: aux false cs
            | aux true [] = raise MalformedCode
            | aux true (#"m"::cs) = aux false cs
            | aux true (c::cs) = aux true cs
          fun strip str = aux false (String.explode str)
            handle MalformedCode => raise Fail ("Malformed Unix code in '" ^ str ^ "'")
          val (ascii,nonascii) = List.partition Char.isAscii (strip str)
        in
          List.length ascii + List.length nonascii div 3
        end
    end
    fun spaces i = String.implode (List.tabulate (i,(fn _ => #" ")))
    fun pad str width =
      let
        val missing = (width - String.size str)
        val left = missing div 2
        val right = missing - left
        val s = spaces left ^ str ^ spaces right
      in
        s
      end
    fun bar i = String.implode (List.tabulate (i,(fn _ => #"-")))
    fun join_trees (size1,size2) =
      fn([],[]) => []
      | (x::xs,[]) => (x ^ spaces size2) :: join_trees (size1,size2) (xs,[])
      | ([],y::ys) => (spaces size1 ^ y) :: join_trees (size1,size2) ([],ys)
      | (x::xs,y::ys) => (x ^ y) :: join_trees (size1,size2) (xs,ys)
    fun proof_to_tree r2s j2s (fold,unfold) proof : int * string list * int =
      let
        val (L,r,j) = unfold proof
        val L = map (proof_to_tree r2s j2s (fold, unfold)) L
        (* val (size,over) = foldl (fn (size2,_,over2) => fn (size1,_,_) => (size1+size2,over2)) (0,"") L *)
        val (size, str, over) = foldl (fn ((size2,str2,over2),(size1,str1,over1)) => (size1+size2,join_trees (size1,size2) (str1,str2),over2)) (0,[],0) L
        (* val (L_len,buffer) = foldr (fn {sub;j;rule;width;over} => fn (i,f) => (width + i + f,over)) (0,0) *)
        val r = " " ^ r2s r ^ " "
        val r_len = String.size r
        val overfill = r_len - over
        val (size,str,over,r) = if overfill > 0 then let val buff = spaces overfill in (size+overfill,map (fn s => s ^ buff) str,over + overfill,r) end else (size,str,over,r ^ spaces (~overfill))
        val j = " " ^ j2s j ^ " "
        val j_len = String.size j
        val overfill = j_len + over - size
        val (size,str,j) = if overfill > 0 then let val size = size + overfill in (size,map (fn s => if String.isPrefix "-" s then bar overfill ^ s else pad s (String.size s + overfill)) str,j ^ spaces over) end else (size,str,pad j (size - over) ^ spaces over)
        val j_len = String.size j
        val r = bar (j_len-over) ^ r
      in
        (size,j::r::str,over)
      end
  in
    fun proof_to_string r2s j2s (fold, unfold) p = ("\n\n" ^ foldr (fn (s,c) => (c ^ s ^ "\n")) "" (#2 (proof_to_tree r2s j2s (fold,unfold) p)) ^ "\n")
  end
end
