structure NDExamples = struct
  open NaturalDeduction 
  
  infixr 9 ^
  infixr 8 v
  infixr 7 >

  infix 4 tru

  (* rule bars starting with a - assume a list of premises *)
  (* rule bars starting with a + assume only one premise *)
  infix 3 -- +--------- ========== +=
  infix 3 --- +-------- ========= +==
  infix 3 ---- +------- ======== +===
  infix 3 ----- +------ ======= +====
  infix 3 ------ +----- ====== +=====
  infix 3 ------- +---- ===== +======
  infix 3 -------- +--- ==== +=======
  infix 3 --------- +-- === +========
  infix 3 ---------- +- == +=========
  
  val imp_refl : proof =
    []
    ----- Hyp "u"
    tru A
    +---- ImpI "u"
    tru A > A
  
  val and_comm : proof = 
    [
      []
      ----- Hyp "u"
      tru A ^ B
      +---- AndE2
      tru B
    ,
      []
      ----- Hyp "u"
      tru A ^ B
      +---- AndE1
      tru A
    ]
    ----- AndI
    tru B ^ A
    +---- ImpI "u"
    tru A ^ B > B ^ A
  val and_comm_verbose : proof = 
    [ 
      [
        [ 
          []
          ---------- Hyp "u"
          tru A ^ B
        ]
        ---------- AndE2
        tru B
      ,
        [ 
          []
          ---------- Hyp "u"
          tru A ^ B
        ]
        ---------- AndE1
        tru A
      ]
      ---------- AndI
      tru B ^ A
    ]
    ---------- ImpI "u"
    tru A ^ B > B ^ A
  val and_comm_again : proof = 
    let
      val prove_b =
          [
            []
            ---------- Hyp "u"
            tru A ^ B
          ]
          ---------- AndE2
          tru B

      val prove_a =
          [
            []
            ---------- Hyp "u"
            tru A ^ B
          ]
          ---------- AndE1
          tru A
      in
          [
            [prove_b, prove_a]
            ---------- AndI
            tru B ^ A
          ]
          ---------- ImpI "u"
          tru A ^ B > B ^ A
    end
end