structure PrettyPrinter : sig

  val pretty_print_proof : ('rule -> string) * ('judgment -> string) -> (Logic.void,Logic.void,'rule,'judgment) Logic.abstractprooftree -> unit

  val pretty_print_prooftree : ('given -> string) * ('theorem -> string) * ('rule -> string) * ('judgment -> string) -> ('given,'theorem,'rule,'judgment) Logic.abstractprooftree -> unit

  val pretty_print_prooftree_hyps : ('given -> string) * ('theorem -> string) * ('rule -> string) * ('judgment -> string) -> ((Logic.hypothesis * 'judgment) list * 'given,'theorem,'rule,'judgment) Logic.abstractprooftree -> unit
  
  val pretty_print_prooftree_hyps_side_by_side : ('given -> string) * ('theorem -> string) * ('rule -> string) * ('judgment -> string) -> ((Logic.hypothesis * 'judgment) list * 'given,'theorem,'rule,'judgment) Logic.abstractprooftree list -> unit

  val pretty_print_prooftree_hyps_side_by_side_with : ('given -> string) * ('theorem -> string) * ('rule -> string) * ('judgment -> string) -> string list -> ((Logic.hypothesis * 'judgment) list * 'given,'theorem,'rule,'judgment) Logic.abstractprooftree list -> unit
  
end = struct
  type ('given,'theorem,'rule,'judgment) printctx = ('given -> string) * ('theorem -> string) * ('rule -> string) * ('judgment -> string)
  open Logic
  structure String = struct open String
    fun size str =
      let
        exception MalformedCode
        fun aux false [] = []
          | aux false (#"\027"::cs) = aux true cs
          | aux false (c::cs) = c :: aux false cs
          | aux true [] = raise MalformedCode
          | aux true (#"m"::cs) = aux false cs
          | aux true (c::cs) = aux true cs
        fun strip str = aux false (String.explode str)
          handle MalformedCode => raise Fail ("Malformed Unix code in '" ^ str ^ "'")
        val (ascii,nonascii) = List.partition Char.isAscii (strip str)
      in
        List.length ascii + List.length nonascii div 3
      end
  end
  fun dummyhypruletostring u = "hyp_" ^ u
  fun spaces i = String.implode (List.tabulate (i,(fn _ => #" ")))
  fun pad str width =
    let
      val missing = (width - String.size str)
      val left = missing div 2
      val right = missing - left
      val s = spaces left ^ str ^ spaces right
    in
      s
    end
  fun bar i = String.implode (List.tabulate (i,(fn _ => #"-")))
  fun join_trees (size1,size2) =
    fn([],[]) => []
    | (x::xs,[]) => (x ^ spaces size2) :: join_trees (size1,size2) (xs,[])
    | ([],y::ys) => (spaces size1 ^ y) :: join_trees (size1,size2) ([],ys)
    | (x::xs,y::ys) => (x ^ y) :: join_trees (size1,size2) (xs,ys)
  fun proof_to_tree (ctx as (given_to_string,theorem_to_string,rule_to_string,judgment_to_string) : (('given),'theorem,'rule,'judgment) printctx) ((ProofTree (L,r,j)) : ((hypothesis * 'judgment) list * 'given,'theorem,'rule,'judgment) abstractprooftree) : int * string list * int =
    let
      val L = map (proof_to_tree ctx) L
      (* val (size,over) = foldl (fn (size2,_,over2) => fn (size1,_,_) => (size1+size2,over2)) (0,"") L *)
      val (size, str, over) = foldl (fn ((size2,str2,over2),(size1,str1,over1)) => (size1+size2,join_trees (size1,size2) (str1,str2),over2)) (0,[],0) L
      (* val (L_len,buffer) = foldr (fn {sub;j;rule;width;over} => fn (i,f) => (width + i + f,over)) (0,0) *)
      val r = " " ^ rule_to_string r ^ " "
      val r_len = String.size r
      val overfill = r_len - over
      val (size,str,over,r) = if overfill > 0 then let val buff = spaces overfill in (size+overfill,map (fn s => s ^ buff) str,over + overfill,r) end else (size,str,over,r ^ spaces (~overfill))
      val j = " " ^ judgment_to_string j ^ " "
      val j_len = String.size j
      val overfill = j_len + over - size
      val (size,str,j) = if overfill > 0 then let val size = size + overfill in (size,map (fn s => if String.isPrefix "-" s then bar overfill ^ s else pad s (String.size s + overfill)) str,j ^ spaces over) end else (size,str,pad j (size - over) ^ spaces over)
      val j_len = String.size j
      val r = bar (j_len-over) ^ r
    in
      (size,j::r::str,over)
    end
  | proof_to_tree (ctx as (given_to_string,theorem_to_string,rule_to_string,judgment_to_string)) (Given ((hyps,name),j)) =
    let
      fun buildhyp (u,a) =
        let
          val a = " " ^ judgment_to_string a ^ " "
          val a_len = String.size a
          val b = bar a_len
          val r = " hyp_" ^ u ^ " "
          val r_len = String.size r
          val b = b ^ r
          (* val a = a ^ spaces r_len *)
        in
          (a_len + r_len,[a,r],0)
        end
      val L = map buildhyp hyps
      (* val (size,over) = foldl (fn (size2,_,over2) => fn (size1,_,_) => (size1+size2,over2)) (0,"") L *)
      val (size, str, over) = foldl (fn ((size2,str2,over2),(size1,str1,over1)) => (size1+size2,join_trees (size1,size2) (str1,str2),over2)) (0,[],0) L
      (* val (L_len,buffer) = foldr (fn {sub;j;rule;width;over} => fn (i,f) => (width + i + f,over)) (0,0) *)
      (* val r = " " ^ rule_to_string r ^ " " *)
      val r = ""
      val r_len = String.size r
      val overfill = r_len - over
      val r = spaces over
      val g = " " ^ given_to_string name ^ " "
      val j = " " ^ judgment_to_string j ^ " "
      val g_len = String.size g
      val j_len = String.size j
      val maxlen = Int.max (Int.max(g_len,j_len),size)
      val g = pad g maxlen
      val j = pad j maxlen
      val str = map (fn s => pad s maxlen) str
      val overfill = maxlen + over - size
      val (size,str,g,j) = if overfill > 0 then let val size = size + overfill in (size,map (fn s => (if String.isPrefix "-" s then bar else spaces) overfill ^ s) str,g ^ spaces over, j ^ spaces over) end else (size,str,pad g (size - over) ^ spaces over, pad j (size - over) ^ spaces over)
      (* val r = bar (j_len-over) ^ r *)
    in
      (size,j::g::str,over)
    end
  | proof_to_tree ctx (Theorem _) = raise Fail "Unimplemented printing of theorems and givens"
  fun injecthyps proof = case proof of
      ProofTree (ts,r,j) => ProofTree (map injecthyps ts,r,j)
    | Theorem (ts,r,j) => Theorem (map injecthyps ts,r,j)
    | Given (g,j) => Given (([],g),j)

  fun pretty_print_prooftree_hyps ctx p = (print "\n"; foldr (fn (s,()) => print (s ^ "\n")) () (#2 (proof_to_tree ctx p)); print "\n")
  fun pretty_print_prooftree ctx p = pretty_print_prooftree_hyps ctx (injecthyps p)
  fun pretty_print_proof (r2s,j2s) = pretty_print_prooftree (Logic.abort,Logic.abort,r2s,j2s)
  fun pretty_print_prooftree_hyps_side_by_side_with ctx sep L =
    let
      val sep_len = List.foldMapl Int.max String.size 0 sep
      val sep = map (fn s => pad s sep_len) sep
      val sep_tree = (sep_len,sep,0)
      val L = map (proof_to_tree ctx) L
      fun interleave [] = []
        | interleave [p] = [p]
        | interleave (p::ps) = p::sep_tree::interleave ps
      fun pad height (size,str,over) =
        let
          val missing = (height - List.length str)
          val top = missing div 2
          val bottom = missing - top
          val buff = spaces size
          fun lines n = List.tabulate (n,fn _ => buff)
        in
          (size,lines bottom @ str @ lines top,over)
        end
      val L = interleave L
      val max_height = List.foldl (fn ((_,str,_),max) => Int.max (max, List.length str)) 0 L
      val L = map (pad max_height) L
      val p = foldl (fn ((size2,str2,over2),(size1,str1,over1)) => (size1+size2,join_trees (size1,size2) (str1,str2),over2)) (0,[],0) L
    in
      (print "\n"; foldr (fn (s,()) => print (s ^ "\n")) () (#2 p); print "\n")
    end
  
  fun pretty_print_prooftree_hyps_side_by_side ctx L = pretty_print_prooftree_hyps_side_by_side_with ctx [] L
end