structure SequentCalculus = struct
  open Logic

  datatype prop = datatype NaturalDeduction.prop

  (* There is one judgment: the sequent "Gamma ==> C" *)
  datatype judgment
    = JSeq of prop list * prop

  datatype rule
    = Init
    | TrueR
    | FalseL
    | AndR | AndL1 | AndL2
    | OrR1 | OrR2 | OrL
    | ImpR | ImpL

  type given = void
  type theorem = void
  type proof = (void, void, rule, judgment) abstractprooftree
  type ('given,'theorem) prooftree = ('given,'theorem,rule,judgment) abstractprooftree

  (*
   * Macros for writing propositions
   * These will be infixed for you in a HW's starter code if it uses sequent calculus
   *)

  (* Atom proposition shortcuts *)
  val (A,B,C,D,E) = (PAtom AA,PAtom AB,PAtom AC,PAtom AD,PAtom AE)

  (*
   * Connective shortcuts in order of precedence
   * ^ for and
   * v for or
   * > for implies
   * ~ for negation (aka A>F)
   * T for true
   * F for False
   *)
  val (op^,v, op>, ~, T, F) = (PAnd,POr,PImp,fn a => PImp(a,PFalse),PTrue,PFalse)

  (*
   * Truth judgment magic to use with ==>
   * Example Usage:


    [proof_of_A,proof_of_B]
     ---------------------- AndR
      seq [A,A>B] ==> A ^ B

   *)
  fun seq (f,p) = (f,p)
  val ==> = JSeq

end
