structure RuleCreation = struct
  open Logic

  (* Each connective should be treated in isolation *)
  (* We left the number of hypotheses up to you in Intro and Elim *)
  (* If there is only one intro rule use Intro *)
  (* If there are two intro rules use Intro1 and Intro2 *)
  (* The same goes for elim rules *)
  datatype rule =
    Hyp of hypothesis

  (* One rule versions *)
  | Intro of hypothesis list
  | Elim  of hypothesis list

  (* Two rule versions *)
  | Intro1 of hypothesis list | Intro2 of hypothesis list
  | Elim1  of hypothesis list | Elim2  of hypothesis list

  (* A definition of a rule is a proof tree with only the rules above *)
  (* This type also allows for judgments to be "given" *)
  type 'judgment def = ((hypothesis * 'judgment) list * unit,void,rule,'judgment) abstractprooftree

  (* A logic with just the new connective and atoms *)
  datatype prop = PNew of prop list | PAtom of atom

  (* One letter macros for atoms *)
  val (A,B,C,D,E) = (PAtom AA,PAtom AB,PAtom AC,PAtom AD,PAtom AE)
  (* Infix operator for the new connective *)


  (* Macros *)

  (* !A for a new unary connective *)
  fun ! a = PNew [a]
  (* A ? B for a new binary connective *)
  fun ? (a,b) = PNew [a,b]
  (* ??[A,B,C,D] for anything *)
  fun ?? ps = PNew ps

  fun prem a = Given (([],()),a)
  fun prem_hyps hyps a = Given ((hyps,()),a)
  
  (* Simplified Natural Deduction *)
  datatype nd_judgment = JTrue of prop
  type nd_def = nd_judgment def
  fun tru (f,p) = f (JTrue p)
  fun prem_hyps_tru hyps j = prem_hyps (map (fn (x,a) => (x,JTrue a)) hyps) j

  (* Simplified Verifications and Uses *)
  datatype vau_judgment = JUp of prop | JDown of prop
  type vau_def = vau_judgment def
  fun up (f,p) = f (JUp p)
  fun down (f,p) = f (JDown p)
  fun prem_hyps_up hyps j = prem_hyps (map (fn (x,a) => (x,JUp a)) hyps) j
  fun prem_hyps_down hyps j = prem_hyps (map (fn (x,a) => (x,JDown a)) hyps) j

  (* to make prem work, the rules need to be funcs *)
  local val (hyp,i,e,i1,i2,e1,e2) =
    (Hyp,Intro,Elim,Intro1,Intro2,Elim1,Elim2) in
    fun Hyp    H j = (hyp H, j)
    fun Intro  H j = (i   H, j)
    fun Elim   H j = (e   H, j)
    fun Intro1 H j = (i1  H, j)
    fun Intro2 H j = (i2  H, j)
    fun Elim1  H j = (e1  H, j)
    fun Elim2  H j = (e2  H, j)
  end

end