
structure ProofsAsPrograms = struct
  open Logic

  datatype prop = datatype NaturalDeduction.prop

  datatype term
    = Var of hypothesis
    | Unit
    | Abort of term
    | Tuple of term * term
    | Fst of term
    | Snd of term
    | Inl of term
    | Inr of term
    | Case of term * (hypothesis * term) * (hypothesis * term)
    | Lambda of hypothesis * term
    | App of term * term

  (* There is one judgment: that a proof term proves a proposition *)
  datatype judgment
    = JHasType of term * prop
    
  datatype rule = datatype NaturalDeduction.rule
  
  type given = void
  type theorem = void
  type proof = (given, theorem, rule, judgment) abstractprooftree
  type ('given,'theorem) prooftree = ('given,'theorem,rule,judgment) abstractprooftree
  
  (* 
   * Macros for writing propositions
   * These will be infixed for you in a HW's starter code if it uses natural deduction 
   *)

  (* Atom proposition shortcuts *)
  val (A,B,C,D,E) = (PAtom AA,PAtom AB,PAtom AC,PAtom AD,PAtom AE)
  
  (*
   * Connective shortcuts in order of precedence
   * T for truth
   * F for false
   * ~ for negation (aka implying false)
   * ^ for and
   * v for or
   * > for implies
   *)
  val (op^,v, op>, ~, T, F) = (PAnd,POr,PImp,fn a => PImp(a,PFalse), PTrue, PFalse)

  (* 
   * Typing judgment magic to use with -- and ==
   * Example Usage:
     
     [proof_M_of_A,proof_N_of_B]
            --------- AndI
        term Tuple(M,N) hastyp A ^ B
     
   *)
  fun term (f,p) = (f,p)
  val ::: = JHasType
end