structure NaturalDeduction = struct
  open Logic

  datatype prop
    = PTrue
    | PFalse
    | PAtom of atom
    | PAnd of prop * prop
    | POr of prop * prop
    | PImp of prop * prop

  (* There is one judgment: that a proposition is true *)
  datatype judgment
    = JTrue of prop
    
  datatype rule
    = Hyp of hypothesis
    | TrueI
    | FalseE
    | AndI | AndE1 | AndE2
    | OrI1 | OrI2 | OrE of hypothesis * hypothesis
    | ImpI of hypothesis | ImpE
  
  type given = void
  type theorem = void
  type proof = (given, theorem, rule, judgment) abstractprooftree
  type ('given,'theorem) prooftree = ('given,'theorem,rule,judgment) abstractprooftree
  
  (* 
   * Macros for writing propositions
   * These will be infixed for you in a HW's starter code if it uses natural deduction 
   *)

  (* Atom proposition shortcuts *)
  val (A,B,C,D,E) = (PAtom AA,PAtom AB,PAtom AC,PAtom AD,PAtom AE)
  
  (*
   * Connective shortcuts in order of precedence
   * T for truth
   * F for false
   * ~ for negation (aka implying false)
   * ^ for and
   * v for or
   * > for implies
   *)
  val (op^,v, op>, ~, T, F) = (PAnd,POr,PImp,fn a => PImp(a,PFalse), PTrue, PFalse)

  (* 
   * Truth judgment magic to use with -- and ==
   * Example Usage:
     
     [proof_of_A_true,proof_of_B_true]
     --------- AndI
     tru A ^ B
     
   *)
  fun tru (f,p) = (f,JTrue p)
  fun given_hyps hyps name prop = Given ((hyps,name),JTrue prop)
  fun given name prop = given_hyps [] name prop
end