structure LinearLogic = struct
  open Logic
  
  datatype prop
    = PAtom of atom
    | PTensor of prop * prop
    | POne
    | PPlus of prop * prop
    | PZero
    | PWith of prop * prop
    | PTop
    | PLolli of prop * prop

  (* There is one judgment: "Delta ||- C true" that a proposition is true given a context *)
  datatype judgment = JSeq of prop list * prop

  datatype rule
    = Init
    | TensorR | TensorL
    | OneR | OneL
    | WithR | WithL1 | WithL2
    | TopR
    | PlusR1 | PlusR2 | PlusL
    | ZeroL
    | LolliR | LolliL

  type proof = (void, void, rule, judgment) abstractprooftree
  type ('given,'theorem) prooftree = ('given,'theorem,rule,judgment) abstractprooftree

  (*
   * Macros for writing propositions
   * These will be infixed for you in a HW's starter code if it uses natural deduction
   *)

  (* Atom proposition shortcuts *)
  val (A,B,C,D,E) = (PAtom AA,PAtom AB,PAtom AC,PAtom AD,PAtom AE)

  (*
   * Connective shortcuts in order of precedence
   * O for one
   * Z for zero
   * T for top
   * * for tensor
   * & for with
   * + for plus
   * -@ for lolli
   *)
  val (op*,op+,&,-@,O,Z,T) = (PTensor,PPlus,PWith,PLolli,POne,PZero,PTop)

  (*
   * Truth judgment magic to use with -- and ==
   * Example Usage:

     [proof_of_A_true,proof_of_B_true]
     --------- TensorI
     [A,B] ||- A * B

   *)
  fun seq (f,p) = (f,p)
  val ||- = JSeq
  type given = void
  type theorem = void
end
