structure VAUExamples = struct
  open VerificationsAndUses 
  
  infixr 9 ^
  infixr 8 v
  infixr 7 >

  infix 4 up down

  infix 3 -- +--------- ========== +=
  infix 3 --- +-------- ========= +==
  infix 3 ---- +------- ======== +===
  infix 3 ----- +------ ======= +====
  infix 3 ------ +----- ====== +=====
  infix 3 ------- +---- ===== +======
  infix 3 -------- +--- ==== +=======
  infix 3 --------- +-- === +========
  infix 3 ---------- +- == +=========
  
  val imp_refl : proof =
        []
     -------- Hyp "u"
      down A
     +------- DownUp
       up A
    +--------- ImpI "u"
     up A > A
  
  val and_comm : proof = 
    [
      []
      ----- Hyp "u"
      down A ^ B
      +---- AndE2
      down B
      +---- DownUp
      up B
    ,
      []
      ----- Hyp "u"
      down A ^ B
      +---- AndE1
      down A
      +---- DownUp
      up A
    ]
    ----- AndI
    up B ^ A
    +---- ImpI "u"
    up A ^ B > B ^ A
  val and_comm_verbose : proof = 
    [ 
      [
        [
          [ 
            []
            ---------- Hyp "u"
            down A ^ B
          ]
          ---------- AndE2
          down B
        ]
        ---------- DownUp
        up B
      ,
        [
          [ 
            []
            ---------- Hyp "u"
            down A ^ B
          ]
          ---------- AndE1
          down A
        ]
        ---------- DownUp
        up A
      ]
      ---------- AndI
      up B ^ A
    ]
    ---------- ImpI "u"
    up A ^ B > B ^ A
  val and_comm_again : proof = 
    let
      val verify_b =
          []
          ---------- Hyp "u"
          down A ^ B
          +--------- AndE2
          down B
          +--------- DownUp
          up B

      val verify_a =
          []
          ---------- Hyp "u"
          down A ^ B
          +--------- AndE1
          down A
          +--------- DownUp
          up A
      in
          [verify_b, verify_a]
          ---------- AndI
          up B ^ A
          +--------- ImpI "u"
          up A ^ B > B ^ A
    end
end