structure SCExamples = struct
  open SequentCalculus 
  
  infixr 9 ^
  infixr 8 v
  infixr 7 >

  infix 5 ==>

  infix 4 seq

  infix 3 -- +--------- ========== +=
  infix 3 --- +-------- ========= +==
  infix 3 ---- +------- ======== +===
  infix 3 ----- +------ ======= +====
  infix 3 ------ +----- ====== +=====
  infix 3 ------- +---- ===== +======
  infix 3 -------- +--- ==== +=======
  infix 3 --------- +-- === +========
  infix 3 ---------- +- == +=========
  
  val imp_refl : proof =
    [
      []
      ---------- Init
      seq [A] ==> A
    ]
    ---------- ImpR
    seq [] ==> A > A
  
  val and_comm : proof = 
    [ 
    [
      [ []
      ----- Init
      seq [A ^ B, B] ==> B]
      ----- AndL2
      seq [A ^ B] ==> B
    ,
      [ []
      ----- Init
      seq [A ^ B, A] ==> A]
      ----- AndL1
      seq [A ^ B] ==> A
    ]
    ----- AndR
    seq [A ^ B] ==> B ^ A]
    ----- ImpR
    seq [] ==> A ^ B > B ^ A

  val and_comm_nested : proof = 
    [ 
      [
        [ 
          []
          ---------- Init
          seq [A^B,B] ==> B 
        ]
        ---------- AndL2
        seq [A^B] ==> B
      ,
        [ 
          []
          ---------- Init
          seq [A^B,A] ==> A
        ]
        ---------- AndL1
        seq [A^B] ==> A
      ]
      ---------- AndR
      seq [A^B] ==> B ^ A
    ]
    ---------- ImpR
    seq [] ==> A ^ B > B ^ A
  
  val and_comm_again : proof = 
    let
      val verify_b =
          [
            []
            ---------- Init
            seq [A^B,B] ==> B
          ]
          ---------- AndL2
          seq [A^B] ==> B

      val verify_a =
          [
            []
            ---------- Init
            seq [A^B,A] ==> A
          ]
          ---------- AndL1
          seq [A^B] ==> A
      in
          [
            [verify_b, verify_a]
            ---------- AndR
            seq [A^B] ==> B ^ A
          ]
          ---------- ImpR
          seq [] ==> A ^ B > B ^ A
    end
end