structure RCExamples = struct
  open RuleCreation
  
  infixr 9 ^ ?
  infixr 8 v
  infixr 7 >

  infix 4 tru up down

  infix 3 -- +--------- ========== +=
  infix 3 --- +-------- ========= +==
  infix 3 ---- +------- ======== +===
  infix 3 ----- +------ ======= +====
  infix 3 ------ +----- ====== +=====
  infix 3 ------- +---- ===== +======
  infix 3 -------- +--- ==== +=======
  infix 3 --------- +-- === +========
  infix 3 ---------- +- == +=========

  (* When defining a new connective we use ? to indicate the new connective *)
  (* Rules are just labelled as Intro or Elim and unrestricted on number of hypotheses *)
  (* Premises use "prem" as the justificaiton *)
  (* When a premise has hypotheses use "prem_hyp_jjj" for judgment "jjj" hypotheses *)

  val and_intro : nd_def =
    [
      prem
      tru A
    ,
      prem
      tru B
    ]
    ---------- Intro []
    tru A ? B
  
  val and_elim_1 : nd_def =
  
    prem
    tru (A ? B)
    +--------- Elim1 []
    tru A
  
  val and_elim_2 : nd_def =

    prem
    tru A ? B
    +--------- Elim2 []
    tru B
  
  val imp_intro : nd_def =

    prem_hyps_tru [("u",A)]
    tru B
    +--------- Intro ["u"]
    tru (A ? B)

  val imp_down : vau_def =
    [
      prem
      down (A ? B)
    ,
      prem
      up A
    ]
    -------- Elim []
    down B
  
  val or_down : vau_def =
    [
      prem
      down A ? B
    ,
      prem_hyps_down [("u",A)]
      up C
    ,
      prem_hyps_down [("v",B)]
      up C
    ]
    ---------- Elim ["u","v"]
    up C
  
  (* We use double question mark ??[A,B,C] to refer to a connective that has more than two inputs *)
  val superand_intro : nd_def =
    [
      prem
      tru A
    ,
      prem
      tru B
    ,
      prem
      tru C
    ]
    --------- Intro []
    tru ??[A,B,C]
  
  (* And you thought we'd stop with 3 *)
  val superduperand_intro : nd_def =
    [
      prem
      tru A
    ,
      prem
      tru B
    ,
      prem
      tru C
    ,
      prem
      tru D
    ,
      prem
      tru E
    ]
    --------- Intro []
    tru ??[A,B,C,D,E]
end