structure PAPExamples = struct
  open ProofsAsPrograms 
  
  infixr 9 ^
  infixr 8 v
  infixr 7 >

  infix 5 :::

  infix 4 term

  infix 3 -- +--------- ========== +=
  infix 3 --- +-------- ========= +==
  infix 3 ---- +------- ======== +===
  infix 3 ----- +------ ======= +====
  infix 3 ------ +----- ====== +=====
  infix 3 ------- +---- ===== +======
  infix 3 -------- +--- ==== +=======
  infix 3 --------- +-- === +========
  infix 3 ---------- +- == +=========

  val imp_refl : proof =
    (* fn u => u *)
    []
    ----- Hyp "u"
    term Var"u" ::: A
    +---- ImpI "u"
    term Lambda("u", Var"u") ::: A > A
  
  val and_comm : proof = 
    (* fn u => (#2 u, #1 u) *)
    [
      []
      ----- Hyp"u"
      term Var"u" ::: A ^ B
      +---- AndE2
      term Snd (Var"u") ::: B
    ,
      []
      ----- Hyp"u"
      term Var"u" ::: A ^ B
      +---- AndE1
      term Fst (Var"u") ::: A
    ]
    ----- AndI
    term Tuple(Snd (Var"u"), Fst (Var"u")) ::: B ^ A
    +---- ImpI "u"
    term Lambda("u",Tuple(Snd (Var"u"), Fst (Var"u"))) ::: A ^ B > B ^ A
    
  val and_comm_nested : proof = 
    (* fn u => (#2 u, #1 u) *)
    [ 
      [
        [ 
          []
          ---------- Hyp "u"
          term Var"u" ::: A ^ B
        ]
        ---------- AndE2
        term Snd (Var"u") ::: B
      ,
        [ 
          []
          ---------- Hyp "u"
          term Var"u" ::: A ^ B
        ]
        ---------- AndE1
        term Fst (Var"u") ::: A
      ]
      ---------- AndI
      term Tuple(Snd (Var"u"), Fst (Var"u")) ::: B ^ A
    ]
    ---------- ImpI "u"
    term Lambda("u",Tuple(Snd (Var"u"), Fst (Var"u"))) ::: A ^ B > B ^ A
  val and_comm_again : proof = 
    (* fn u => (#2 u, #1 u) *)
    let
      val prove_b =
          []
          ---------- Hyp "u"
          term Var"u" ::: A ^ B
          +--------- AndE2
          term Snd (Var"u") ::: B

      val prove_a =
          []
          ---------- Hyp "u"
          term Var"u" ::: A ^ B
          +--------- AndE1
          term Fst (Var"u") ::: A
      in
          [prove_b, prove_a]
          ---------- AndI
          term Tuple(Snd (Var"u"), Fst (Var"u")) ::: B ^ A
          +--------- ImpI "u"
          term Lambda("u",Tuple(Snd (Var"u"), Fst (Var"u"))) ::: A ^ B > B ^ A
    end
  val or_comm : proof =
    (* fn u => case u of Inl x => Inr x | Inr y => Inl y *)
    [
      []
      ---------- Hyp "u"
      term Var"u" ::: A v B
    ,
      []
      ---------- Hyp "x"
      term Var"x" ::: A
      +--------- OrI2
      term Inr (Var"x") ::: B v A
    ,
      []
      ---------- Hyp "y"
      term Var"y" ::: B
      +--------- OrI1
      term Inl (Var"y") ::: B v A
    ]
    ---------- OrE ("x","y")
    term Case (Var"u",("x",Inr (Var"x")),("y",Inl (Var"y"))) ::: B v A
    +--------- ImpI "u"
    term Lambda("u",Case (Var"u",("x",Inr (Var"x")),("y",Inl (Var"y")))) ::: A v B > B v A
end