structure CNDExamples = struct
  open ContextNaturalDeduction 

  infixr 9 ^
  infixr 8 v
  infixr 7 >

  infix 5 |-

  infix 4 tru

  infix 3 -- +--------- ========== +=
  infix 3 --- +-------- ========= +==
  infix 3 ---- +------- ======== +===
  infix 3 ----- +------ ======= +====
  infix 3 ------ +----- ====== +=====
  infix 3 ------- +---- ===== +======
  infix 3 -------- +--- ==== +=======
  infix 3 --------- +-- === +========
  infix 3 ---------- +- == +=========
  
  val imp_refl : proof =
    
    []
    ---------- Hyp
    tru [A] |- A
    +--------- ImpI
    tru [] |- A > A
  
  val and_comm : proof =  
    [
      []
      ----- Hyp
      tru [A ^ B] |- A ^ B
      +---- AndE2
      tru [A ^ B] |- B
    ,
      []
      ----- Hyp
      tru [A ^ B] |- A ^ B
      +---- AndE1
      tru [A ^ B] |- A
    ]
    ----- AndI
    tru [A ^ B] |- B ^ A
    +---- ImpI
    tru [] |- A ^ B > B ^ A
  val and_comm_verbose : proof = 
    [ 
      [
        [ 
          []
          ---------- Hyp
          tru [A ^ B] |- A ^ B
        ]
        ---------- AndE2
        tru [A ^ B] |- B
      ,
        [ 
          []
          ---------- Hyp
          tru [A ^ B] |- A ^ B
        ]
        ---------- AndE1
        tru [A ^ B] |- A
      ]
      ---------- AndI
      tru [A ^ B] |- B ^ A
    ]
    ---------- ImpI
    tru [] |- A ^ B > B ^ A
  val and_comm_again : proof = 
    let
      val prove_b =
          []
          ---------- Hyp
          tru [A ^ B] |- A ^ B
          +--------- AndE2
          tru [A ^ B] |- B

      val prove_a =
          []
          ---------- Hyp
          tru [A ^ B] |- A ^ B
          +--------- AndE1
          tru [A ^ B] |- A
      in
          [prove_b, prove_a]
          ---------- AndI
          tru [A ^ B] |- B ^ A
          +--------- ImpI
          tru [] |- A ^ B > B ^ A
    end
  
  val imp_apply : proof =
  (* (A > B) > A > B) *)

    [
      []
      ---------- Hyp
      tru [A>B,A] |- A>B
    ,
      []
      ---------- Hyp
      tru [A>B,A] |- A
    ]
    ---------- ImpE
    tru [A>B,A] |- B
    +--------- ImpI
    tru [A>B] |- A > B
    +--------- ImpI
    tru [] |- (A > B) > A > B

end