structure Homework4 : HOMEWORK4 = struct
  (* Atomics *)
  infix 9 eq
  
  (* Propositions *)
  infixr 8 ^ ?
  infixr 7 v
  infixr 6 >
  
  (* Type annotations *)
  infix 5 :::
  
  (* Contexts *)
  infix 5 |-
  
  (* Judgments *)
  infix 4 tru up down term obj nat seq
  
  (* Proofs *)
  (* The different lengths are just for astetics *)
  (* Starting with a plus means only one premise (proof vs proof list) *)
  infix 3 -- +--------- ========== +=
  infix 3 --- +-------- ========= +==
  infix 3 ---- +------- ======== +===
  infix 3 ----- +------ ======= +====
  infix 3 ------ +----- ====== +=====
  infix 3 ------- +---- ===== +======
  infix 3 -------- +--- ==== +=======
  infix 3 --------- +-- === +========
  infix 3 ---------- +- == +=========
  
  (* Visualize your proofs in the repl with Out *)
  
  (****************************)
  (* Student code begins here *)
  (****************************)

  (*
   * Task 1
   * Distributivity of exists over disjunction
   * 
   * 12 points
   *)

  local open HeytingArithmetic in
  
  (* Forward Direction *)
  val distribute : HeytingArithmetic.proof =
  
    []
    ---------- Hyp "unimplemented"
    tru (exi "x" tau (Aof (var "x") v Bof (var "x"))) > (exi "x" tau (Aof (var "x")) v exi "x" tau (Bof (var "x")))
  
  (* Backward Direction *)
  val undistribute : HeytingArithmetic.proof =
  
    []
    ---------- Hyp "unimplemented"
    tru (exi "x" tau (Aof (var "x")) v exi "x" tau (Bof (var "x"))) > (exi "x" tau (Aof (var "x") v Bof (var "x")))

  (*
   * Task 2
   * Equivalence of exists and the negation of forall
   * 
   * 8 points
   *)

  (* Proof of forward direction or NONE *)
  val forall_to_exists : HeytingArithmetic.proof option =
  SOME
  (
  
    []
    ---------- Hyp "unimplemented"
    tru ~(for "x" tau (~(Aof (var "x")))) > exists "x" tau (Aof (var "x"))
  )
  
  (* Proof of backward direction or NONE *)
  val exists_to_forall : HeytingArithmetic.proof option =
  SOME
  (
  
    []
    ---------- Hyp "unimplemented"
    tru (exists "x" tau (Aof (var "x"))) > ~(for "x" tau (~(Aof (var "x"))))
  )

  (*
   * Task 3
   * Fix a judgement by replacing T with something more useful and then prove the fixed judgement
   * 
   * 8 points
   *)

  (* Provide a proposition to replace T with *)
  (* Don't use F or Aof *)
  val your_prop : HeytingArithmetic.prop =
  
    T
  
  (* Replace T in the proposition and prove it *)
  val foralltheexists : HeytingArithmetic.proof =
    []
    ---------- Hyp "Unimplemented"
    tru (for "x" tau (Aof (var "x"))) ^ your_prop > exi "y" tau (Aof (var "y"))
  
  end

  (*
   * Task 4
   * Prove transitivity of equality for Nats
   * 
   * 12 points
   *)

  local open HeytingArithmetic in
  val transitivity : HeytingArithmetic.proof =
  
    []
    --------- Hyp "unimplemented"
    tru for "x" Nat (for "y" Nat (for "z" Nat ((var "x") eq (var "y") ^ (var "y") eq (var "z") > (var "x") eq (var "z"))))
  
  end
end