structure InversionG4ip = struct
  open Logic

  datatype prop = datatype NaturalDeduction.prop
  (* The type of right non-invertible propositions *)
  datatype pos
    = PosOr of prop * prop
    | PosFalse
    | PosAtom of atom
  (* The type of left non-invertible propositions *)
  datatype neg
    = NegImpAtom of atom * prop
    | NegImpImp of (prop * prop) * prop
    | NegAtom of atom
  

  (* Inversion G4IP has three judgments:
   * Right inversion
   * 
   *     Delta-;Omega -R-> C
   *
   * Left inversion
   *
   *     Delta-;Omega -L-> C+
   *
   * Search
   *
   *     Delta- -S-> C+
   *)
  datatype judgment
    = JInvR of neg list * prop list * prop
    | JInvL of neg list * prop list * pos
    | JSearch of neg list * pos

  datatype rule
    (* right inversion rules *)
    = ImpR | AndR | TrueR | Switch
    (* left inversion rules *)
    | OrL | TrueL | AndL | FalseL
    | ImpTrueL | ImpFalseL | ImpAndL | ImpOrL
    | Shift | Search
    (* search rules *)
    | Init | ImpAtomL | ImpImpL
    | OrR1 | OrR2
  
  type given = void
  type theorem = void
  type proof = (given, theorem, rule, judgment) abstractprooftree
  type ('given,'theorem) prooftree = ('given,'theorem,rule,judgment) abstractprooftree
  
  
end