
structure Harmony = struct
  open RuleCreation

  (* Sometimes we give back proof trees that not only have a name like DD or EE, but also has subsitution like [EE/u]DD. *)

  (* Substitutions are a series of [D/x][E/y]F replacements *)
  (* Now in addition to being given proofs DD or EE, we have substitutions [M/x]DD *)
  datatype givensubst = GivenName of givenname | GivenSubst of (givenname,hypothesis) slash list * givenname

  (* We allow now givens to have substitution *)
  (* To leave a judgment unproved, name the missing proof and the hypotheses it expects *)
  type given = (hypothesis * nd_judgment) list * givensubst
  (* No theorems needed for harmony *)
  type theorem = void
  (* The rules are just ?I and ?E *)
  (* The proposions are just atoms and A ? B *)
  (* The only judgment is "true" *)
  type proof = (given,theorem,rule,nd_judgment) abstractprooftree

  (* A local reduction consists of two proof trees *)
  type localreductions = (proof * proof) list
  (* A local expansion consists of two proof trees *)
  type localexpansion  = (proof * proof)

  (* Macros *)
  fun given d a = Given (([],GivenName d),a)
  fun given_hyps_tru hyps d a = Given ((map (fn(u,a)=>(u,JTrue a)) hyps,GivenName d),a)
  fun subst substs d a = Given (([],GivenSubst (substs,d)),a)
  fun subst_hyps_tru hyps substs d a = Given ((map (fn(u,a)=>(u,JTrue a)) hyps,GivenSubst (substs,d)),a)
  
end